package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.EnclosureInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.EnclosureInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.EnclosureInfo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 特种设备附件资料信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class EnclosureInfoService extends AppBaseService<EnclosureInfoModel, EnclosureInfo, EnclosureInfoMapper> {

    /**
     *
     * 新增特种设备附件资料信息
     *
     * @param model 特种设备附件资料信息实体类集合
     * @return 成功返回“OK”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveEnclosureInfo(List<EnclosureInfo> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("特种设备附件资料信息为空.");
        }

        for (EnclosureInfo models : model) {
            models.setRecDate(new Date());
            models.setAppId(getAppId());
        }
        this.saveBatch(model);
        return "OK";
    }
}
