package com.yeejoin.amos.boot.module.common.api.enums;

import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 需要提级的行政区划
 */
@Getter
public enum ReginStepEnum {

    /**
     * 杨凌区
     */
    YANGLING("610403", "杨陵区", "map"),
    /**
     * 西咸新区
     */
    XIXIAN("617000", "西咸新区", "map"),
    /**
     * 韩城市
     */
    HANCHENG("610581", "韩城市", "map");


    private final String code;

    private final String name;

    private final String type;

    ReginStepEnum(String code, String name, String type) {
        this.code = code;
        this.name = name;
        this.type = type;
    }

    public static List<RegionModel> enum2RegionList(String type) {
        return Arrays.stream(ReginStepEnum.values()).filter(e -> e.getType().equals(type)).map(e -> {
            RegionModel regionModel = new RegionModel();
            regionModel.setRegionCode(Integer.parseInt(e.getCode()));
            regionModel.setRegionName(e.getName());
            return regionModel;
        }).collect(Collectors.toList());
    }
}
