package com.yeejoin.amos.boot.module.jczs.api.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.RegUnitIcDto;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.RegUnitInfoDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 企业数据信息Dto
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TzBaseEnterpriseInfoDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	/**
	 * id
	 */
	private Long sequenceNbr;
	@ApiModelProperty(value = "使用单位唯一标识")
	/**
	 * 使用单位唯一标识
	 */
	private String useUnitCode;
	@ApiModelProperty(value = "监管系统唯一编码")
	/**
	 * 监管系统唯一编码
	 */
	private String superviseCode;
	@ApiModelProperty(value = "使用单位证件类型")
	/**
	 * 使用单位证件类型
	 */
	private String useUnitCertificate;
	@ApiModelProperty(value = "单位类型")
	/**
	 * 单位类型
	 */
	private String unitType;
	@ApiModelProperty(value = "使用单位统一信用代码")
	/**
	 * 使用单位统一信用代码
	 */
	private String useCode;

	@ApiModelProperty(value = "根据统一信用代码生成的二维码")
	private String qrCode;

	@ApiModelProperty(value = "使用单位名称")
	/**
	 * 使用单位名称
	 */
	private String useUnit;
	@ApiModelProperty(value = "监管机构组织机构代码")
	/**
	 * 监管机构组织机构代码
	 */
	private String superviseOrgCode;
	@ApiModelProperty(value = "监管机构名称")
	/**
	 * 监管机构名称
	 */
	private String superviseOrgName;
	@ApiModelProperty(value = "是否重点监控单位")
	/**
	 * 是否重点监控单位
	 */
	private String keyUnit;
	@ApiModelProperty(value = "重点场所分类")
	/**
	 * 重点场所分类
	 */
	private String classPlaces;
	@ApiModelProperty(value = "单位所在省份名称")
	/**
	 * 单位所在省份名称
	 */
	private String province;
	@ApiModelProperty(value = "单位所在城市名称")
	/**
	 * 单位所在城市名称
	 */
	private String city;
	@ApiModelProperty(value = "单位所在区县名称")
	/**
	 * 单位所在区县名称
	 */
	private String district;
	@ApiModelProperty(value = "单位所在街道名称")
	/**
	 * 单位所在街道名称
	 */
	private String street;
	@ApiModelProperty(value = "单位所在社区名称")
	/**
	 * 单位所在社区名称
	 */
	private String community;
	@ApiModelProperty(value = "单位详细地址")
	/**
	 * 单位详细地址
	 */
	private String address;
	@ApiModelProperty(value = "使用单位法人")
	/**
	 * 使用单位法人
	 */
	private String legalPerson;
	@ApiModelProperty(value = "法人联系电话")
	/**
	 * 法人联系电话
	 */
	private String legalPhone;
	@ApiModelProperty(value = "使用单位联系人")
	/**
	 * 使用单位联系人
	 */
	private String useContact;
	@ApiModelProperty(value = "联系人联系电话")
	/**
	 * 联系人联系电话
	 */
	private String contactPhone;
	@ApiModelProperty(value = "安全管理人员1姓名")
	/**
	 * 安全管理人员1姓名
	 */
	private String safetyOne;
	@ApiModelProperty(value = "安全管理人员1身份证")
	/**
	 * 安全管理人员1身份证
	 */
	private String safetyOneId;
	@ApiModelProperty(value = "安全管理人员1联系电话")
	/**
	 * 安全管理人员1联系电话
	 */
	private String safetyOnePhone;
	@ApiModelProperty(value = "安全管理人员2")
	/**
	 * 安全管理人员2
	 */
	private String safetyTwo;
	@ApiModelProperty(value = "安全管理人员2身份证")
	/**
	 * 安全管理人员2身份证
	 */
	private String safetyTwoId;
	@ApiModelProperty(value = "安全管理人员2联系电话")
	/**
	 * 安全管理人员2联系电话
	 */
	private String safetyTwoPhone;
	@ApiModelProperty(value = "单位地理坐标经度")
	/**
	 * 单位地理坐标经度
	 */
	private String longitude;
	@ApiModelProperty(value = "单位地理坐标纬度")
	/**
	 * 单位地理坐标纬度
	 */
	private String latitude;
	@ApiModelProperty(value = "同步时间")
	/**
	 * 同步时间
	 */
	private Date syncDate;
	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	/**
	 * 同步状态（0-新增 1-更新 2-删除）
	 */
	private Integer syncState;
	@ApiModelProperty(value = "对接公司编码")
	/**
	 * 对接公司编码
	 */
	private String appId;
	@ApiModelProperty(value = "创建时间")
	/**
	 * 创建时间
	 */
	private Date recDate;
	@ApiModelProperty(value = "操作人员")
	/**
	 * 操作人员
	 */
	private String recUserId;
	@ApiModelProperty(value = "管辖机构")
	/**
	 * 管辖机构
	 */
	private String governingBody;
	@ApiModelProperty(value = "数据来源")
	/**
	 * 数据来源
	 */
	private String dataSources;
	@ApiModelProperty(value = "所属行业")
	/**
	 * 所属行业
	 */
	private String industry;
	@ApiModelProperty(value = "登记机关")
	/**
	 * 登记机关
	 */
	private String registrationAuthority;
	@ApiModelProperty(value = "核准时间")
	/**
	 * 核准时间
	 */
	private Date approvalTime;

	/**
	 * 核准时间(企业端基础信息使用)
	 */
	@ApiModelProperty(value = "核准时间")
	private String approval;

	@ApiModelProperty(value = "经营状态")
	/**
	 * 经营状态
	 */
	private String operatingStatus;
	@ApiModelProperty(value = "维保负责人")
	/**
	 * 维保负责人
	 */
	private String maintenPerson;
	@ApiModelProperty(value = "维保负责人联系电话")
	/**
	 * 维保负责人联系电话
	 */
	private String maintenTelephone;
	@ApiModelProperty(value = "质量保证工程师")
	/**
	 * 质量保证工程师
	 */
	private String sqa;
	@ApiModelProperty(value = "质量负责人")
	/**
	 * 质量负责人
	 */
	private String qualityPerson;
	@ApiModelProperty(value = "质量负责人电话")
	/**
	 * 质量负责人电话
	 */
	private String qualityTelephone;
	@ApiModelProperty(value = "技术负责人")
	/**
	 * 技术负责人
	 */
	private String technicalPerson;

	@ApiModelProperty(value = "涉及设备类型")
	private List equipCategory;

	@ApiModelProperty(value = "企业营业执照")
	private List unitBusinessLicense;

	@ApiModelProperty(value = "企业许可证书")
	private List unitExequatur;

	@ApiModelProperty(value = "安全管理人2身份证照片")
	private List safetyTwoPhoto;

	@ApiModelProperty(value = "安全管理人1身份证照片")
	private List safetyOnePhoto;

	@ApiModelProperty(value = "质量保证工程师电话")
	private String sqaPhone;

    @ApiModelProperty(value = "行业主管部门")
    private String industrySupervisor;


	private String region;

	private String fullAddress;

	private String superviseKey;

	private List<BaseUnitLicenceDto> unitLicences;

	private RegUnitIcDto regUnitIcDto;
	//企业管理员信息
	private RegUnitInfoDto regUnitInfoDto;


	@ApiModelProperty(value = "企业标签信息")
	private String regulatoryLabels;
}
