package com.yeejoin.amos.boot.module.statistcs.biz.controller;


import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.AQZSDPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "大屏-安全追溯及气瓶统计Api")
@RequestMapping(value = "/dp/aqzs")
public class AQZSDPStatisticsController {

    private AQZSDPStatisticsServiceImpl statisticsService;

    public AQZSDPStatisticsController(AQZSDPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-气瓶-区域安全指数")
    @PostMapping(value = "/security-index")
    public ResponseModel<Map<String, Object>> getSecurityIndex(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult bindingResult) throws Exception {
        List<FieldError> fieldErrors = bindingResult.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Map<String, Object> result = statisticsService.getSecurityIndex(dpFilterParamDto);
        return ResponseHelper.buildResponse(result);
    }
    
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-气瓶-区域安全指数统计")
    @RequestMapping(value = "/earlyWarning/child", method = RequestMethod.POST)
    public ResponseModel<Map<String, Object>> getChildEarlyWarning(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult bindingResult) throws Exception {
        List<FieldError> fieldErrors = bindingResult.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getChildEarlyWarning(dpFilterParamDto));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-左屏-问题类型主体统计")
    @PostMapping(value = "/mainBodyCount")
    public ResponseModel<Map<String, Object>> mainBodyCount(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.mainBodyCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-左屏-设备问题近30天统计")
    @PostMapping(value = "/equipmentCount")
    public ResponseModel<Map<String, Object>> equipmentCount(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.equipmentCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-左屏-企业问题近30天统计")
    @PostMapping(value = "/companyCount")
    public ResponseModel<List<Map<String, Object>>> companyCount(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = statisticsService.companyCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-左屏-人员问题近30天统计")
    @PostMapping(value = "/personCount")
    public ResponseModel<Map<String, Object>> personCount(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.personCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    ;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-左屏-气瓶问题近30天统计")
    @PostMapping(value = "/cylinderCount")
    public ResponseModel<Map<String, Object>> cylinderCount(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.cylinderCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-右屏-按月统计近12个月的问题数量趋势")
    @PostMapping(value = "/issueCountByMonth")
    public ResponseModel<Map<String, Object>> issueCountByMonth(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.issueCountByMonth(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-右屏-按月统计近30天的问题数量趋势")
    @PostMapping(value = "/issueCountByDay")
    public ResponseModel<Map<String, Object>> issueCountByDay(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.issueCountByDay(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-中屏-当前区域数据统计")
    @PostMapping(value = "/issueCountByCityCodeOld")
    public ResponseModel<Map<String, Object>> issueCountByCityCode(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.issueCountByCityCode(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-中屏-当前区域子区域数据统计")
    @PostMapping(value = "/issueChildrenCityCountOld")
    public ResponseModel<List<Map<String, Object>>> issueChildrenCityCount(@RequestBody Map<String, Object> map) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = statisticsService.issueChildrenCityCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-左屏-当月问题列表（主体类型、问题类型、问题时间、操作）")
    @PostMapping(value = "/issueMonthList")
    public ResponseModel<List<Map<String, Object>>> issueMonthList(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = statisticsService.issueMonthList(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-右屏-当年问题等级分类统计")
    @PostMapping(value = "/issueProblemLevelCount")
    public ResponseModel<Map<String, Object>> issueProblemLevelCount(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = statisticsService.issueProblemLevelCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-右屏-按问题类型排名top 10")
    @PostMapping(value = "/issueCompanyTop")
    public ResponseModel<List<Map<String, Object>>> issueCompanyTop(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = statisticsService.issueCompanyTop(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-安全追溯-同设备近30天按问题次数滚动", notes = "大屏-安全追溯-同设备近30天按问题次数滚动")
    @PostMapping(value = "/equip-question/list")
    public ResponseModel<List<Map<String, Object>>> getEquipQuestionList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getEquipQuestionList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-右屏-当年下级区域问题闭环率排名")
    @PostMapping(value = "/issueChildrenCityCountTop")
    public ResponseModel<List<Map<String, Object>>> issueChildrenCityCountTop(@RequestBody Map<String, Object> map) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = statisticsService.issueChildrenCityCountTop(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "大屏-安全追溯-右屏-按问题类型排名top 10")
    @PostMapping(value = "/issueCountTopByProblemType")
    public ResponseModel<List<Map<String, Object>>> issueCountTopByProblemType(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = statisticsService.issueCountTopByProblemType(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-中间地图左右两侧8大类、单位、人员数量、问题数量全局统计", notes = "大屏中间-地图左右两侧8大类、单位、人员数量、问题数量全局统计")
    @PostMapping(value = "/issueCountByCityCode")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "安全追溯大屏-中间地图地市统计", notes = "安全追溯大屏中间-地图地市统计")
    @PostMapping(value = "/issueChildrenCityCount")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) throws Exception {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }
}
