package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.entity.AlertStatistics;
import com.yeejoin.amos.boot.module.statistics.api.mapper.AlertStatisticsMapper;
import com.yeejoin.amos.boot.module.common.api.enums.UnitTypeEnum;
import com.yeejoin.amos.boot.module.common.api.enums.UserPostEnum;
import com.yeejoin.amos.boot.module.statistics.api.mapper.ZLStatisticsMapper;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class ZLDPStatisticsServiceImpl {


    private ZLStatisticsMapper screenMapper;


    private DataDictionaryServiceImpl iDataDictionaryService;

    private AlertStatisticsMapper alertStatisticsMapper;

    private RestHighLevelClient restHighLevelClient;

    private StCommonServiceImpl stCommonService;

    public ZLDPStatisticsServiceImpl(ZLStatisticsMapper screenMapper, DataDictionaryServiceImpl iDataDictionaryService, AlertStatisticsMapper alertStatisticsMapper, RestHighLevelClient restHighLevelClient, StCommonServiceImpl stCommonService) {
        this.screenMapper = screenMapper;
        this.iDataDictionaryService = iDataDictionaryService;
        this.alertStatisticsMapper = alertStatisticsMapper;
        this.restHighLevelClient = restHighLevelClient;
        this.stCommonService = stCommonService;
    }


    public List<Map<String, Object>> companyInfo(DPFilterParamDto screenDto) {

        List<Map<String,Object>> list = screenMapper.getCompanyInfo(screenDto);
        List<Map<String,Object>> returnList = new ArrayList<>();

        //数据处理后Map，key为企业类型+设备，value为计数
        Map<String, Integer> dataMap = new HashMap<>();
        for(Map<String,Object> map : list){
            if(null == map.get("equipCategory") || CollectionUtils.isEmpty((JSONArray) JSONArray.parse((String) map.get("equipCategory")))){
                String[] UnitTypeArray = ((String) map.get("unitType")).split("#");
                for (int i = 0; i < UnitTypeArray.length; i++) {
                    String unitTypeName = UnitTypeArray[i];
                    if (dataMap.containsKey(unitTypeName + "null")) {
                        dataMap.put(unitTypeName + "null", dataMap.get(unitTypeName + "null") + 1);
                    } else {
                        dataMap.put(unitTypeName + "null", 1);
                    }
                }
            }else {
                JSONArray equipCategoryArray = (JSONArray) JSONArray.parse((String) map.get("equipCategory"));
                String[] UnitTypeArray = ((String) map.get("unitType")).split("#");
                for (int i = 0; i < UnitTypeArray.length; i++) {
                    String unitTypeName = UnitTypeArray[i];
                    for (int j = 0; j < equipCategoryArray.size(); j++) {
                        if (dataMap.containsKey(unitTypeName + equipCategoryArray.get(j))) {
                            dataMap.put(unitTypeName + equipCategoryArray.get(j), dataMap.get(unitTypeName + equipCategoryArray.get(j)) + 1);
                        } else {
                            dataMap.put(unitTypeName + equipCategoryArray.get(j), 1);
                        }
                    }
                }
            }
        }
        /**
         * 4000	起重机械
         * 3000	电梯
         * 5000	场（厂）内机动车辆
         * 1000	锅炉
         * 2000	压力容器
         * 6000	大型游乐设施（B类）
         * 9000	客运索道
         * 8000 压力管道
         */



        //充装Map
        Map<String,Object> chongzhuangMap = new HashMap<>();
        List<Map<String,Object>> chongzhuangCompanyList = new ArrayList<>();
        chongzhuangMap.put("key","chongzhuangCompany");
        chongzhuangMap.put("value","充装单位");
        //充装压力容器
        Map<String,Object> chongzhuangyalirongqiMap = new HashMap<>();
        chongzhuangyalirongqiMap.put("key","key04");
        chongzhuangyalirongqiMap.put("name","气瓶");
        chongzhuangyalirongqiMap.put("value",dataMap.getOrDefault("充装单位2000",0));
        chongzhuangCompanyList.add(chongzhuangyalirongqiMap);
        chongzhuangMap.put("data",chongzhuangCompanyList);
        //无设备类型
        Map<String,Object> chongzhuangNullMap = new HashMap<>();
        chongzhuangNullMap.put("key","key09");
        chongzhuangNullMap.put("name","无设备类型");
        chongzhuangNullMap.put("value",dataMap.getOrDefault("充装单位null",0));
        chongzhuangCompanyList.add(chongzhuangNullMap);
        chongzhuangMap.put("data",chongzhuangCompanyList);

        //安改维Map
        Map<String,Object> angaiweiMap = new HashMap<>();
        List<Map<String,Object>> angaiweiCompanyList = new ArrayList<>();
        angaiweiMap.put("key","angaiweiCompany");
        angaiweiMap.put("value","安改维单位");
        //安改维电梯
        Map<String,Object> angaiweidiantiMap = new HashMap<>();
        angaiweidiantiMap.put("key","key01");
        angaiweidiantiMap.put("name","电梯");
        angaiweidiantiMap.put("value",dataMap.getOrDefault("安装改造维修单位3000",0));
        angaiweiCompanyList.add(angaiweidiantiMap);
        //安改维锅炉
        Map<String,Object> angaiweiguoluMap = new HashMap<>();
        angaiweiguoluMap.put("key","key02");
        angaiweiguoluMap.put("name","锅炉");
        angaiweiguoluMap.put("value",dataMap.getOrDefault("安装改造维修单位1000",0));
        angaiweiCompanyList.add(angaiweiguoluMap);
        //安改维场内机动车
        Map<String,Object> angaiweijidongcheMap = new HashMap<>();
        angaiweijidongcheMap.put("key","key03");
        angaiweijidongcheMap.put("name","场内机动车");
        angaiweijidongcheMap.put("value",dataMap.getOrDefault("安装改造维修单位5000",0));
        angaiweiCompanyList.add(angaiweijidongcheMap);
        //安改维压力管道
        Map<String,Object> angaiweiyaliguandaoMap = new HashMap<>();
        angaiweiyaliguandaoMap.put("key","key05");
        angaiweiyaliguandaoMap.put("name","压力管道");
        angaiweiyaliguandaoMap.put("value",dataMap.getOrDefault("安装改造维修单位9000",0));
        angaiweiCompanyList.add(angaiweiyaliguandaoMap);
        //安改维起重机械
        Map<String,Object> angaiweiqizhongjixieMap = new HashMap<>();
        angaiweiqizhongjixieMap.put("key","key06");
        angaiweiqizhongjixieMap.put("name","起重机械");
        angaiweiqizhongjixieMap.put("value",dataMap.getOrDefault("安装改造维修单位4000",0));
        angaiweiCompanyList.add(angaiweiqizhongjixieMap);
        //安改维游乐设施
        Map<String,Object> angaiweiyoulesheshiMap = new HashMap<>();
        angaiweiyoulesheshiMap.put("key","key07");
        angaiweiyoulesheshiMap.put("name","大型游乐设施");
        angaiweiyoulesheshiMap.put("value",dataMap.getOrDefault("安装改造维修单位6000",0));
        angaiweiCompanyList.add(angaiweiyoulesheshiMap);
        //安改维客运索道
        Map<String,Object> angaiweikeyunsuodaoMap = new HashMap<>();
        angaiweikeyunsuodaoMap.put("key","key08");
        angaiweikeyunsuodaoMap.put("name","客运索道");
        angaiweikeyunsuodaoMap.put("value",dataMap.getOrDefault("安装改造维修单位9000",0));
        angaiweiCompanyList.add(angaiweikeyunsuodaoMap);
        angaiweiMap.put("data",angaiweiCompanyList);
        //无设备类型
        Map<String,Object> angaiweiNullMap = new HashMap<>();
        angaiweiNullMap.put("key","key09");
        angaiweiNullMap.put("name","无设备类型");
        angaiweiNullMap.put("value",dataMap.getOrDefault("安装改造维修单位null",0));
        angaiweiCompanyList.add(angaiweiNullMap);
        angaiweiMap.put("data",angaiweiCompanyList);

        //设计Map
        Map<String,Object> shejiMap = new HashMap<>();
        List<Map<String,Object>> shejiCompanyList = new ArrayList<>();
        shejiMap.put("key","shejiCompany");
        shejiMap.put("value","设计单位");
        //设计压力容器
        Map<String,Object> shejiyalirongqiMap = new HashMap<>();
        shejiyalirongqiMap.put("key","key04");
        shejiyalirongqiMap.put("name","压力容器");
        shejiyalirongqiMap.put("value",dataMap.getOrDefault("设计单位2000",0));
        shejiCompanyList.add(shejiyalirongqiMap);
        //设计压力管道
        Map<String,Object> shejiyaliguandaoMap = new HashMap<>();
        shejiyaliguandaoMap.put("key","key05");
        shejiyaliguandaoMap.put("name","压力管道");
        shejiyaliguandaoMap.put("value",dataMap.getOrDefault("设计单位8000",0));
        shejiCompanyList.add(shejiyaliguandaoMap);
        shejiMap.put("data",shejiCompanyList);

        //制造Map
        Map<String,Object> zhizaoMap = new HashMap<>();
        List<Map<String,Object>> zhizaoCompanyList = new ArrayList<>();
        zhizaoMap.put("key","zhizaoCompany");
        zhizaoMap.put("value","制造单位");
        //制造电梯
        Map<String,Object> zhizaodiantiMap = new HashMap<>();
        zhizaodiantiMap.put("key","key01");
        zhizaodiantiMap.put("name","电梯");
        zhizaodiantiMap.put("value",dataMap.getOrDefault("制造单位3000",0));
        zhizaoCompanyList.add(zhizaodiantiMap);
        //制造锅炉
        Map<String,Object> zhizaoguoluMap = new HashMap<>();
        zhizaoguoluMap.put("key","key02");
        zhizaoguoluMap.put("name","锅炉");
        zhizaoguoluMap.put("value",dataMap.getOrDefault("制造单位1000",0));
        zhizaoCompanyList.add(zhizaoguoluMap);
        //制造锅炉
        Map<String,Object> zhizaojidongcheMap = new HashMap<>();
        zhizaojidongcheMap.put("key","key03");
        zhizaojidongcheMap.put("name","场内机动车");
        zhizaojidongcheMap.put("value",dataMap.getOrDefault("制造单位5000",0));
        zhizaoCompanyList.add(zhizaojidongcheMap);
        //制造压力容器
        Map<String,Object> zhizaoyalirongqiMap = new HashMap<>();
        zhizaoyalirongqiMap.put("key","key04");
        zhizaoyalirongqiMap.put("name","压力容器");
        zhizaoyalirongqiMap.put("value",dataMap.getOrDefault("制造单位2000",0));
        zhizaoCompanyList.add(zhizaoyalirongqiMap);
        //制造起重机械
        Map<String,Object> zhizaoqizhongjixieMap = new HashMap<>();
        zhizaoqizhongjixieMap.put("key","key06");
        zhizaoqizhongjixieMap.put("name","起重机械");
        zhizaoqizhongjixieMap.put("value",dataMap.getOrDefault("制造单位4000",0));
        zhizaoCompanyList.add(zhizaoqizhongjixieMap);
        //制造游乐设施
        Map<String,Object> zhizaoyoulesheshiMap = new HashMap<>();
        zhizaoyoulesheshiMap.put("key","key07");
        zhizaoyoulesheshiMap.put("name","大型游乐设施");
        zhizaoyoulesheshiMap.put("value",dataMap.getOrDefault("制造单位6000",0));
        zhizaoCompanyList.add(zhizaoyoulesheshiMap);
        //制造客运索道
        Map<String,Object> zhizaokeyunsuodaoMap = new HashMap<>();
        zhizaokeyunsuodaoMap.put("key","key08");
        zhizaokeyunsuodaoMap.put("name","客运索道");
        zhizaokeyunsuodaoMap.put("value",dataMap.getOrDefault("制造单位9000",0));
        zhizaoCompanyList.add(zhizaokeyunsuodaoMap);
        zhizaoMap.put("data",zhizaoCompanyList);
        //无设备类型
        Map<String,Object> zhizaoNullMap = new HashMap<>();
        zhizaoNullMap.put("key","key09");
        zhizaoNullMap.put("name","无设备类型");
        zhizaoNullMap.put("value",dataMap.getOrDefault("制造单位null",0));
        zhizaoCompanyList.add(zhizaoNullMap);
        zhizaoMap.put("data",zhizaoCompanyList);

        //使用Map
        Map<String,Object> shiyongMap = new HashMap<>();
        List<Map<String,Object>> shiyongCompanyList = new ArrayList<>();
        shiyongMap.put("key","shiyongCompany");
        shiyongMap.put("value","使用单位");
        //使用电梯
        Map<String,Object> shiyongdiantiMap = new HashMap<>();
        shiyongdiantiMap.put("key","key01");
        shiyongdiantiMap.put("name","电梯");
        shiyongdiantiMap.put("value",dataMap.getOrDefault("使用单位3000",0));
        shiyongCompanyList.add(shiyongdiantiMap);
        //使用锅炉
        Map<String,Object> shiyongguoluMap = new HashMap<>();
        shiyongguoluMap.put("key","key02");
        shiyongguoluMap.put("name","锅炉");
        shiyongguoluMap.put("value",dataMap.getOrDefault("使用单位1000",0));
        shiyongCompanyList.add(shiyongguoluMap);
        //使用锅炉
        Map<String,Object> shiyongjidongcheMap = new HashMap<>();
        shiyongjidongcheMap.put("key","key03");
        shiyongjidongcheMap.put("name","场内机动车");
        shiyongjidongcheMap.put("value",dataMap.getOrDefault("使用单位5000",0));
        shiyongCompanyList.add(shiyongjidongcheMap);
        //使用压力容器
        Map<String,Object> shiyongyalirongqiMap = new HashMap<>();
        shiyongyalirongqiMap.put("key","key04");
        shiyongyalirongqiMap.put("name","压力容器");
        shiyongyalirongqiMap.put("value",dataMap.getOrDefault("使用单位2000",0));
        shiyongCompanyList.add(shiyongyalirongqiMap);
        //使用压力管道
        Map<String,Object> shiyongyaliguandaoMap = new HashMap<>();
        shiyongyaliguandaoMap.put("key","key05");
        shiyongyaliguandaoMap.put("name","压力管道");
        shiyongyaliguandaoMap.put("value",dataMap.getOrDefault("使用单位9000",0));
        shiyongCompanyList.add(shiyongyaliguandaoMap);
        //使用起重机械
        Map<String,Object> shiyongqizhongjixieMap = new HashMap<>();
        shiyongqizhongjixieMap.put("key","key06");
        shiyongqizhongjixieMap.put("name","起重机械");
        shiyongqizhongjixieMap.put("value",dataMap.getOrDefault("使用单位4000",0));
        shiyongCompanyList.add(shiyongqizhongjixieMap);
        //使用游乐设施
        Map<String,Object> shiyongyoulesheshiMap = new HashMap<>();
        shiyongyoulesheshiMap.put("key","key07");
        shiyongyoulesheshiMap.put("name","大型游乐设施");
        shiyongyoulesheshiMap.put("value",dataMap.getOrDefault("使用单位6000",0));
        shiyongCompanyList.add(shiyongyoulesheshiMap);
        //使用客运索道
        Map<String,Object> shiyongkeyunsuodaoMap = new HashMap<>();
        shiyongkeyunsuodaoMap.put("key","key08");
        shiyongkeyunsuodaoMap.put("name","客运索道");
        shiyongkeyunsuodaoMap.put("value",dataMap.getOrDefault("使用单位9000",0));
        shiyongCompanyList.add(shiyongkeyunsuodaoMap);
        shiyongMap.put("data",shiyongCompanyList);
        //无设备类型
        Map<String,Object> shiyongNullMap = new HashMap<>();
        shiyongNullMap.put("key","key09");
        shiyongNullMap.put("name","无设备类型");
        shiyongNullMap.put("value",dataMap.getOrDefault("使用单位null",0));
        shiyongCompanyList.add(shiyongNullMap);
        shiyongMap.put("data",shiyongCompanyList);

        returnList.add(zhizaoMap);
        returnList.add(angaiweiMap);
        returnList.add(shiyongMap);
        returnList.add(shejiMap);
        returnList.add(chongzhuangMap);

        return returnList;
    }

    public List<Map<String, Object>> testOrg(DPFilterParamDto screenDto) {
        List<Map<String, Object>> list = screenMapper.testOrg(screenDto);
        List<Map<String, Object>> returnList = new ArrayList<>();
        Map<String, Object> dataMap = new HashMap<>();
        for (int i = 0; i < list.size(); i++) {
            dataMap.put((String) list.get(i).get("agencyType"), list.get(i).get("count"));
        }
        /**
         * 1	甲类检验机构A1级
         * 2	甲类检验机构A2级
         * 4	甲类检验机构B1级
         * 5	甲类检验机构B2级
         * 6	乙类检验机构
         * 7	丙类检验机构
         * 8	检测机构
         * 9	综合检验机构甲类（旧规）
         * 10	综合检验机构乙类（旧规）
         * 11	综合检验机构丙类（旧规）
         * 12	自检机构（旧规）
         * 13	气瓶检验机构（旧规）
         * 14	无损检测机构（旧规）
         */
        Map<String, Object> newMap = new HashMap<>();
        newMap.put("key", "new");
        newMap.put("name", "新分类");
        List<Map<String, Object>> newList = new ArrayList<>();
        Map<String, Object> newMap1 = new HashMap<>();
        newMap1.put("name", "甲类检验机构A1级");
        newMap1.put("value", dataMap.getOrDefault("1", 0));
        newList.add(newMap1);
        Map<String, Object> newMap2 = new HashMap<>();
        newMap2.put("name", "甲类检验机构A2级");
        newMap2.put("value", dataMap.getOrDefault("2", 0));
        newList.add(newMap2);
        Map<String, Object> newMap3 = new HashMap<>();
        newMap3.put("name", "甲类检验机构B1级");
        newMap3.put("value", dataMap.getOrDefault("4", 0));
        newList.add(newMap3);
        Map<String, Object> newMap4 = new HashMap<>();
        newMap4.put("name", "甲类检验机构B2级");
        newMap4.put("value", dataMap.getOrDefault("5", 0));
        newList.add(newMap4);
        Map<String, Object> newMap5 = new HashMap<>();
        newMap5.put("name", "乙类检验机构");
        newMap5.put("value", dataMap.getOrDefault("6", 0));
        newList.add(newMap5);
        Map<String, Object> newMap6 = new HashMap<>();
        newMap6.put("name", "丙类检验机构");
        newMap6.put("value", dataMap.getOrDefault("7", 0));
        newList.add(newMap6);
        Map<String, Object> newMap7 = new HashMap<>();
        newMap7.put("name", "检测机构");
        newMap7.put("value", dataMap.getOrDefault("8", 0));
        newList.add(newMap7);
        newMap.put("data", newList);
        Map<String, Object> oldMap = new HashMap<>();
        oldMap.put("key", "old");
        oldMap.put("name", "旧分类");
        List<Map<String, Object>> oldList = new ArrayList<>();
        Map<String, Object> oldMap1 = new HashMap<>();
        oldMap1.put("name", "综合检验机构甲类（旧规）");
        oldMap1.put("value", dataMap.getOrDefault("9", 0));
        oldList.add(oldMap1);
        Map<String, Object> oldMap2 = new HashMap<>();
        oldMap2.put("name", "综合检验机构乙类（旧规）");
        oldMap2.put("value", dataMap.getOrDefault("10", 0));
        oldList.add(oldMap2);
        Map<String, Object> oldMap3 = new HashMap<>();
        oldMap3.put("name", "综合检验机构丙类（旧规）");
        oldMap3.put("value", dataMap.getOrDefault("11", 0));
        oldList.add(oldMap3);
        Map<String, Object> oldMap4 = new HashMap<>();
        oldMap4.put("name", "自检机构（旧规）");
        oldMap4.put("value", dataMap.getOrDefault("12", 0));
        oldList.add(oldMap4);
        Map<String, Object> oldMap5 = new HashMap<>();
        oldMap5.put("name", "气瓶检验机构（旧规）");
        oldMap5.put("value", dataMap.getOrDefault("13", 0));
        oldList.add(oldMap5);
        Map<String, Object> oldMap6 = new HashMap<>();
        oldMap6.put("name", "无损检测机构（旧规）");
        oldMap6.put("value", dataMap.getOrDefault("14", 0));
        oldList.add(oldMap6);
        oldMap.put("data", oldList);
        returnList.add(newMap);
        returnList.add(oldMap);
        return returnList;
    }


    public Map<String, Object> userCount(DPFilterParamDto screenDto) {
        List<Map<String, String>> list = screenMapper.userCount(screenDto);
        Map<String, Integer> dataMap = new HashMap<>();
        for (Map<String, String> map : list) {
            String[] split = map.get("unitType").split("#");
            for (int i = 0; i < split.length; i++) {
                if (dataMap.containsKey(split[i])) {
                    dataMap.put(split[i], dataMap.get(split[i]) + 1);
                } else {
                    dataMap.put(split[i], 1);
                }
            }
        }
        List<String> xlist = Arrays.asList("制造单位", "安改维单位", "使用单位", "设计单位", "充装单位");
        List<Integer> ylist = new ArrayList();
        xlist.stream().forEach(x -> {
            ylist.add(dataMap.getOrDefault(x, 0));
        });
        Map<String, Object> returnMap = new HashMap<>();
        returnMap.put("xdata", xlist);
        returnMap.put("ydata", ylist);
        return returnMap;
    }


    public Map<String, Object> supervisorCount(DPFilterParamDto screenDto) {
        List<Map<String, Object>> list = screenMapper.supervisorCount(screenDto);
        Map<String, Integer> dataMap = new HashMap<>();
        for (Map<String, Object> map : list) {
            dataMap.put((String) map.get("industrySupervisor"), Integer.valueOf(map.get("count").toString()));
        }

        List<DataDictionary> dataDictionaryList = iDataDictionaryService.getByType("HYZGBM");
        List<String> xlist = dataDictionaryList.stream().map(DataDictionary::getName).collect(Collectors.toList());
        List<Object> ylist = new ArrayList();
        dataDictionaryList.stream().forEach(x -> {
            ylist.add(dataMap.getOrDefault(x.getCode(), 0));
        });
        Map<String, Object> returnMap = new HashMap<>();
        returnMap.put("xdata", xlist);
        returnMap.put("ydata", ylist);
        return returnMap;
    }


    public List<Map<String, Object>> equipmentInformCount(DPFilterParamDto screenDto) {
        SearchRequest searchRequest = new SearchRequest("idx_biz_view_jg_all");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        //设置模糊搜索
        String orgCode = stCommonService.getAndSetOrgCode(screenDto.getCityCode());
        searchSourceBuilder.query(QueryBuilders.boolQuery()
                .must(QueryBuilders.wildcardQuery("ORG_BRANCH_CODE.keyword", QueryParser.escape(orgCode) + "*")));
        searchSourceBuilder.aggregation(AggregationBuilders.terms("count_by_use_site_code").field("USE_SITE_CODE").size(500));
        searchRequest.source(searchSourceBuilder);
        Map<String, Integer> dataMap = new HashMap<>();
        List<Map<String, Object>> returnList = new ArrayList<>();
        try {
            // 执行搜索请求
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            // 获取所有聚合结果
            Aggregations aggregations = searchResponse.getAggregations();
            Terms termsResult = aggregations.get("count_by_use_site_code");

            for (Terms.Bucket bucket : termsResult.getBuckets()) {
                String category = bucket.getKeyAsString(); // 或者使用 bucket.getKey() 对于非字符串类型
                long docCount = bucket.getDocCount();
                dataMap.put(category, (int) docCount);
            }
            List<DataDictionary> dataDictionaryList = iDataDictionaryService.getByType("ADDRESS");
            dataDictionaryList.stream().forEach(x -> {
                Map<String, Object> map = new HashMap<>();
                map.put("name", x.getName());
                map.put("value", dataMap.getOrDefault(x.getCode(), 0));
                dataMap.remove(x.getCode());
                returnList.add(map);
            });
            Map<String, Object> otherMap = new HashMap<>();
            otherMap.put("name", "其他");
            otherMap.put("value", dataMap.values().stream().mapToLong(e -> e).sum());
            returnList.add(otherMap);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return returnList;
    }


    public Map<String,Object> userCountNew(DPFilterParamDto screenDto) {
        List<String> unitTypeList = UnitTypeEnum.getNameListByType(screenDto.getCompanyType());
        List<Map<String, String>> userListMap = UserPostEnum.getEnumListByType(screenDto.getCompanyType());
        List<Map<String, String>> list = screenMapper.userCountNew(screenDto, unitTypeList);
        Map<String, Integer> dataMap = new HashMap<>();
        for (Map<String, String> map : list) {
            JSONArray jsonArray = JSONArray.parseArray(map.get("post"));
            for(int j = 0; j < jsonArray.size(); j++){
                dataMap.put(jsonArray.getString(j), dataMap.getOrDefault(jsonArray.getString(j), 1) + 1);
            }
        }
        Map<String, Object> returnMap = new HashMap<>();
        List<Object> xdata = new ArrayList<>();
        List<Object> ydata = new ArrayList<>();
        for (Map<String, String> map : userListMap) {
            xdata.add(map.get("name"));
            ydata.add(dataMap.getOrDefault(map.get("code"), 0));
        }
        returnMap.put("xdata", xdata);
        returnMap.put("ydata", ydata);
        return returnMap;
    }

    public JSONArray statisticInfoByRegionAndDate(DPFilterParamDto params) {
        LocalDate today = LocalDate.now();
        LocalDate startDate;
        LocalDate endDate;
        String regionCode = params.getCityCode();
        if (ObjectUtils.isEmpty(params.getBeginDate()) || ObjectUtils.isEmpty(params.getBeginDate())) {
            startDate = today.minusDays(6);
            endDate = today;
        } else {
            startDate = LocalDate.parse(params.getBeginDate());
            endDate = LocalDate.parse(params.getEndDate());
        }
        params.setBeginDate(startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        params.setEndDate(endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        AlertStatistics statistics = alertStatisticsMapper.statisticsInfoByRegionAndDate(regionCode, startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JSONArray jsonArray = new JSONArray();
        if (!ObjectUtils.isEmpty(statistics)) {
            JSONObject jsonObject0 = new JSONObject();
            jsonObject0.put("key", "dtkr");
            jsonObject0.put("value", ValidationUtil.isEmpty(statistics.getTrappedPeople()) ? 0 : statistics.getTrappedPeople());
            jsonObject0.put("name", "电梯困人");

            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("key", "slts");
            jsonObject1.put("value", ValidationUtil.isEmpty(statistics.getComplaint()) ? 0 : statistics.getComplaint());
            jsonObject1.put("name", "受理投诉");

            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put("key", "gzbx");
            jsonObject2.put("value", ValidationUtil.isEmpty(statistics.getBreakdownRescue()) ? 0 : statistics.getBreakdownRescue());
            jsonObject2.put("name", "故障维修");

            JSONObject jsonObject3 = new JSONObject();
            jsonObject3.put("key", "jjbkck");
            jsonObject3.put("value", ValidationUtil.isEmpty(statistics.getRescuePersonnel()) ? 0 : statistics.getRescuePersonnel());
            jsonObject3.put("name", "解救被困乘客");

            JSONObject jsonObject4 = new JSONObject();
            jsonObject4.put("key", "30fzdd");
            jsonObject4.put("value", ValidationUtil.isEmpty(statistics.getWithinThirtyRescue()) ? 0 : statistics.getWithinThirtyRescue());
            jsonObject4.put("name", "30分钟内到达");

            JSONObject jsonObject5 = new JSONObject();
            jsonObject5.put("key", "pjjysj");
            jsonObject5.put("value", ValidationUtil.isEmpty(statistics.getAvgTime()) ? 0 : statistics.getAvgTime());
            jsonObject5.put("name", "平均救援时间");

            String orgCode = stCommonService.getAndSetOrgCode(regionCode);
            JSONObject jsonObject6 = new JSONObject();
            jsonObject6.put("key", "jycq");
            jsonObject6.put("value", orgCode == null ? 0L: this.getQuestionNumber("检验超期",params, orgCode));
            jsonObject6.put("name", "检验超期");

            JSONObject jsonObject7 = new JSONObject();
            jsonObject7.put("key", "jybhg");
            jsonObject7.put("value", orgCode == null ? 0L: this.getQuestionNumber("检验不合格",params, orgCode));
            jsonObject7.put("name", "检验不合格");

            JSONObject jsonObject8 = new JSONObject();
            jsonObject8.put("key", "wbcq");
            jsonObject8.put("value", orgCode == null ? 0L: this.getQuestionNumber("维保超期",params, orgCode));
            jsonObject8.put("name", "维保超期");

            JSONObject jsonObject9 = new JSONObject();
            jsonObject9.put("key", "csjsynx");
            jsonObject9.put("value", orgCode == null ? 0L: this.getQuestionNumber("超设计使用年限",params, orgCode));
            jsonObject9.put("name", "超设计使用年限");

            JSONObject jsonObject10 = new JSONObject();
            jsonObject10.put("key", "zzlq");
            jsonObject10.put("value", orgCode == null ? 0L: stCommonService.getYellowStatusCompany(params).getLongValue());
            jsonObject10.put("name", "许可临期");

            JSONObject jsonObject11 = new JSONObject();
            jsonObject11.put("key", "zzcq");
            jsonObject11.put("value", orgCode == null ? 0L: stCommonService.getRedStatusCompany(params).getLongValue());
            jsonObject11.put("name", "许可超期");

            jsonArray.add(jsonObject0);
            jsonArray.add(jsonObject1);
            jsonArray.add(jsonObject2);
            jsonArray.add(jsonObject3);
            jsonArray.add(jsonObject4);
            jsonArray.add(jsonObject5);
            jsonArray.add(jsonObject6);
            jsonArray.add(jsonObject7);
            jsonArray.add(jsonObject8);
            jsonArray.add(jsonObject9);
            jsonArray.add(jsonObject10);
            jsonArray.add(jsonObject11);

        }
        return jsonArray;
    }

    private Long getQuestionNumber(String problemType, DPFilterParamDto params, String orgCode) {
        return alertStatisticsMapper.countProblemByTypeDateAndOrgCode(problemType, params, orgCode);
    }
}
