package com.yeejoin.amos.boot.module.cylinder.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 问题信息列表
 *
 * @author system_generator
 * @date 2024-06-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "CylinderQuestionInfoDto", description = "问题信息列表")
public class CylinderQuestionInfoDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "行政区划")
    private String regionCode;

    @ApiModelProperty(value = "问题类型枚举")
    private String questionType;

    @ApiModelProperty(value = "问题内容")
    private String questionContent;

    @ApiModelProperty(value = "发生日期")
    private Date happenDate;

    @ApiModelProperty(value = "等级")
    private String level;

    @ApiModelProperty(value = "预警对象唯一标识")
    private String questionObjectId;

    @ApiModelProperty(value = "预警对象名称")
    private String questionObjectName;

    @ApiModelProperty(value = "问题归属唯一标识")
    private String questionAttributionId;

    @ApiModelProperty(value = "问题归属名称")
    private String questionAttributionName;

    @ApiModelProperty(value = "问题类型名称")
    private String questionTypeName;

}
