package com.yeejoin.amos.patrol.business.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel(value = "InputItemDataJsonlDto", description = "检查项JSON数据")
@Data
public class InputItemDataJsonlDto extends BaseDto {

    @ApiModelProperty(value = "合格评分数")
    private Integer okScore;

    @ApiModelProperty(value = "不合格评分数")
    private Integer noScore;

    @ApiModelProperty(value = "合格判断方法")
    private String checkType;

    @ApiModelProperty(value = "有效值上限")
    private Integer validUp;

    @ApiModelProperty(value = "有效值下限")
    private Integer validDown;

    @ApiModelProperty(value = "合格值上限")
    private Integer okUp;

    @ApiModelProperty(value = "合格值下限")
    private Integer okDown;

    @ApiModelProperty(value = "强制校验，输入值不能大于有效值上限")
    private String checkValidUp;

    @ApiModelProperty(value = "强制校验，输入值不能小于有效值下限")
    private String checkValidDown;

    @ApiModelProperty(value = "合格判断，输入值大于合格值上限时为不合格")
    private String checkOkUp;

    @ApiModelProperty(value = "合格判断，输入值小于合格值上限时为不合格")
    private String checkOkDown;

    @ApiModelProperty(value = "小数点后位数")
    private Integer precision;

    public String getCheckValidUp() {
        if (checkValidUp != null) {
            return  checkValidUp.equals("true") ? "是":"否";
        }

        return checkValidUp;
    }

    public String getCheckValidDown() {
        if (checkValidDown != null) {
            return  checkValidDown.equals("true") ? "是":"否";
        }
        return checkValidDown;
    }

    public String getCheckOkUp() {
        if (checkOkUp != null) {
            return  checkOkUp.equals("true") ? "是":"否";
        }
        return checkOkUp;
    }

    public String getCheckOkDown() {
        if (checkOkDown != null) {
            return  checkOkDown.equals("true") ? "是":"否";
        }
        return checkOkDown;
    }
}
