package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.api.dto.JgResumeInfoDto;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgResumeInfoServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 监管履历信息表
 * @author LiuLin
 * @date 2024-05-29
 */
@RestController
@Api(tags = "监管履历信息表Api")
@RequestMapping(value = "/jg-resume-info")
public class JgResumeInfoController extends BaseController {

    @Autowired
    JgResumeInfoServiceImpl jgResumeInfoServiceImpl;

    /**
     * 新增监管履历信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<JgResumeInfoDto> save(@RequestBody JgResumeInfoDto model) {
	    model = jgResumeInfoServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
	 * 新增监管履历信息表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveBatchResume")
	@ApiOperation(httpMethod = "POST", value = "批量新增", notes = "批量新增")
	public void saveBatchResume(@RequestBody List<JgResumeInfoDto> jgResumeInfoDtoList) {
		jgResumeInfoServiceImpl.saveBatchResume(jgResumeInfoDtoList);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<JgResumeInfoDto> updateBySequenceNbrJgResumeInfo(@RequestBody JgResumeInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgResumeInfoServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgResumeInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<JgResumeInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgResumeInfoServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<JgResumeInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgResumeInfoDto> page = new Page<JgResumeInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgResumeInfoServiceImpl.queryForJgResumeInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgResumeInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgResumeInfoServiceImpl.queryForJgResumeInfoList());
	}
}
