package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectConstruction;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 管道工程装置表 Mapper 接口
 *
 * @author system_generator
 * @date 2024-12-11
 */
public interface IdxBizJgProjectContraptionMapper extends BaseMapper<IdxBizJgProjectContraption> {

    Map<String, Object> getDetail(@Param("sequenceNbr") String sequenceNbr);

    List<Map<String, Object>> selectEquipList(@Param("sequenceNbr") String sequenceNbr);

    /**
     * 统计工程装置的引用次数（非待提交、非已撤回、非已驳回）
     *
     * @param projectContraptionId 工程装置唯一标识
     * @return 被引用次数 > 0 则设备不可编辑
     */
    Integer countContraptionInUseTimesForEdit(@Param("projectContraptionId") Long projectContraptionId);

    /**
     * 统计设备被引用的次数（只有存在就算引用-作废除外）
     * @param projectContraptionId 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    Integer countContraptionInUseTimesForDelete(@Param("projectContraptionId") Long projectContraptionId);

    List<IdxBizJgProjectContraption> selectErrorManagementProject();


    /**
     *  查询检验的装置
     * @param page 分页
     * @param inspectionType 检验类型
     * @param companyCode 公司code
     * @param equCategory 设备类别
     * @return 分页
     */
    IPage<IdxBizJgProjectContraption> queryJgProjectContraptionPage(Page<IdxBizJgProjectContraption> page, @Param("inspectionType") String inspectionType, @Param("companyCode") String companyCode, @Param("equCategory") String equCategory);

    /**
     * 获取管道信息分页
     * @param sequenceNbr
     * @param current
     * @param size
     * @return
     */
    List<Map<String, Object>> selectEquipListPage(@Param("sequenceNbr") String sequenceNbr, @Param("current") int current, @Param("size") int size);

    /**
     * 获取管道信息总数
     * @param sequenceNbr
     * @return
     */
    long selectEquipCount(@Param("sequenceNbr") String sequenceNbr);

    /**
     * 获取导出传输/公共管道的信息
     * @param sequenceNbr
     * @return
     */
    List<Map<String, Object>> selectEquipListByExport(@Param("sequenceNbr") String sequenceNbr);

    /**
     * 获取不为空的检验信息个数
     */
    int selectCheckCountByNotNull(@Param("sequenceNbr") String sequenceNbr);

    /**
     * 统计已纳管设备被引用的次数（只有存在就算引用-作废除外）
     * @param projectContraptionId 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    Integer countContraptionInUseTimesForDeleteByIntoManagement(@Param("projectContraptionId")Long projectContraptionId);
}
