package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.dto.OrgMenuDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgPersonDto;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.UnitInfoDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.UnitPersonInfoDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.IUnitPersonService;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.UnitInfoChangeServiceImpl;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 企业人员
 *
 * @author system_generator
 * @date 2021-11-11
 */
@RestController
@Api(tags = "企业人员Api")
@RequestMapping(value = "/flc-unit-person")
public class UnitPersonController extends BaseController {

	@Autowired
	RedisUtils redisUtils;

	@Autowired
	IUnitPersonService iUnitPersonService;

    @Autowired
    OrgUsrServiceImpl iOrgUsrService;

	@Autowired
	UnitInfoChangeServiceImpl unitInfoChangeServiceImpl;

	@Autowired
	DataDictionaryServiceImpl iDataDictionaryService;


	/**
	 * 新增人员信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增人员信息", notes = "新增人员信息")
	public ResponseModel<?> saveOrgUsr(@RequestBody UnitPersonInfoDto unitPersonInfoDto)  {
		if (ValidationUtil.isEmpty(unitPersonInfoDto.getParentId()) || ValidationUtil.isEmpty(unitPersonInfoDto.getParentName()) ) {
			throw new BadRequest("参数校验失败.");
		}
		return ResponseHelper.buildResponse( iUnitPersonService.saveUser(unitPersonInfoDto));
	}

	/**
	 * 根据当前登录人获取企业信息列表 所在单位 以及  所属组织
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/companyTree")
	@ApiOperation(httpMethod = "GET",value = "根据当前登录人获取企业树（所在单位以及所属组织）",  notes = "根据当前登录人获取企业树（所在单位以及所属组织）")
	public ResponseModel<List<OrgMenuDto>> getUserUnit()  throws Exception {
		AgencyUserModel user = Privilege.agencyUserClient.getme().getResult();
		List<CompanyModel> companys = user.getCompanys();
		List<OrgMenuDto> menus = new ArrayList<>();
		for(CompanyModel c : companys) {
			OrgUsr temp = iOrgUsrService.getOne(new LambdaQueryWrapper<OrgUsr>().eq(OrgUsr::getIsDelete,false).eq(OrgUsr::getAmosOrgId,c.getSequenceNbr()));
			if(temp != null) {
				menus = iOrgUsrService.getTreeFlc(Long.parseLong(temp.getAmosOrgId()), iOrgUsrService.selectCompanyDepartmentMsg(), OrgUsr.class.getName(), "getSequenceNbr", 2, "getBizOrgName", "getAmosOrgId", "getBizOrgType");
			}
		}
		return ResponseHelper.buildResponse(menus);
	}


    /**
     * 根据所在单位生成人员code
     * @param companyId
     * @return
     * @throws Exception
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getOrgCode/{companyId}")
    @ApiOperation(httpMethod = "GET",value = "根据当前登录人获取企业树",  notes = "根据当前登录人获取企业树")
    public ResponseModel<String> getOrgCode(@PathVariable Long companyId)  throws Exception {
        OrgUsr company = iOrgUsrService.getById(companyId);
        String code = company.getBizOrgCode() + iOrgUsrService.getOrgCodeStr();
        return ResponseHelper.buildResponse(code);
    }

	/**
	 * 获取资质证书种类
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getLicenceType")
	@ApiOperation(httpMethod = "GET",value = "获取资质证书种类",  notes = "获取资质证书种类")
	public ResponseModel<List<DataDictionary>> getLicenceType() {
		List<DataDictionary>  list = iDataDictionaryService.list(new LambdaQueryWrapper<DataDictionary>().eq(DataDictionary::getIsDelete,false).eq(DataDictionary::getType,"PERSON_QUALITY_TYPE").isNull(DataDictionary::getParent));
		return ResponseHelper.buildResponse(list);
	}

	/**
	 * 根据证书种类编号获取相关项目及代号
	 * @return
	 * @throws Exception
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getProjectInfo/{licenceTypes}")
	@ApiOperation(httpMethod = "GET",value = "根据证书种类编号获取相关项目及代号",  notes = "根据证书种类编号获取相关项目及代号")
	public ResponseModel<List<DataDictionary>> getProjectInfo(@PathVariable String licenceTypes) {
		String[] licenceType = licenceTypes.split(",");
		List<DataDictionary>  list = iDataDictionaryService.list(new LambdaQueryWrapper<DataDictionary>().eq(DataDictionary::getIsDelete,false).eq(DataDictionary::getType,"PERSON_QUALITY_TYPE").in(DataDictionary::getParent,licenceType));
		return ResponseHelper.buildResponse(list);
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr  主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个用户信息",  notes = "根据sequenceNbr查询单个用户信息")
	public ResponseModel<UnitPersonInfoDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse( iUnitPersonService.getPersonById(sequenceNbr));
	}

	/**
	 * 根据当前登录人获取人员信息 带分页搜索
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/listMyUnitPerson")
	@ApiOperation(httpMethod = "GET",value = "根据当前登录人获取人员信息 带分页搜索",  notes = "根据当前登录人获取人员信息 带分页搜索")
	public ResponseModel<Object> listMyUnitPerson(@RequestParam(required = false) Map<String, Object> requestBody)  throws Exception {
		AgencyUserModel user = Privilege.agencyUserClient.getme().getResult();
		List<CompanyModel> companys = user.getCompanys();
		List<OrgMenuDto> menus = new ArrayList<>();
		Long parentId = -1l;
		for(CompanyModel c : companys) {
			OrgUsr temp = iOrgUsrService.getOne(new LambdaQueryWrapper<OrgUsr>().eq(OrgUsr::getIsDelete,false).eq(OrgUsr::getAmosOrgId,c.getSequenceNbr()));
			parentId = temp.getSequenceNbr();
		}
		return ResponseHelper.buildResponse(iUnitPersonService.pagePerson(parentId,requestBody.get("pageNum").toString(),requestBody.get("pageSize").toString(), requestBody));
	}



}
