package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 锅炉-技术参数定义
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("1000")
public class BoilerTechParamsDefine implements ITechParamDefine {

    @TechnicalParameter(key = "deviceLevel", label = "设备级别", type = TechnicalParameter.ParamType.STRING, dictCode = "GLJB")
    private String deviceLevel;


    @TechnicalParameter(key = "ratedEvaporationCapacityThermalPower", label = "额定蒸发量（热功率）", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "t/h(MW)")
    private BigDecimal ratedEvaporationCapacityThermalPower;


    @TechnicalParameter(key = "ratedWorkingPressure", label = "额定工作压力", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal ratedWorkingPressure;


    @TechnicalParameter(key = "ratedOperatingTemperature", label = "额定工作温度", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal ratedOperatingTemperature;


    @TechnicalParameter(key = "designThermalEfficiency", label = "设计热效率", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "%")
    private BigDecimal designThermalEfficiency;


    @TechnicalParameter(key = "feedwaterTemperature", label = "给水温度", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal feedwaterTemperature;


    @TechnicalParameter(key = "ratedOutletReturnWaterOilTemperature", label = "额定出/回水(油)温度", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal ratedOutletReturnWaterOilTemperature;


    @TechnicalParameter(key = "waterOilVolumeOfBoilerProper", label = "锅炉本体水（油）容积", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "L")
    private BigDecimal waterOilVolumeOfBoilerProper;


    @TechnicalParameter(key = "hydraulicTestMediumPressureOfPackagedBoilerBody", label = "整装锅炉本体液压试验介质/压力", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal hydraulicTestMediumPressureOfPackagedBoilerBody;


    @TechnicalParameter(key = "inletOutletTemperatureOfReheater", label = "再热器进（出）口温度", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal inletOutletTemperatureOfReheater;


    @TechnicalParameter(key = "reheaterInletOutletPressure", label = "再热器进（出）口压力", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal reheaterInletOutletPressure;


    @TechnicalParameter(key = "reheatSteamFlow", label = "再热蒸汽流量", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "t/h")
    private BigDecimal reheatSteamFlow;


    @TechnicalParameter(key = "glAirtightTest", label = "有机热载体锅炉气密试验介质/压力", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal glAirtightTest;


    @TechnicalParameter(key = "fuelType", label = "燃料（热源）种类", type = TechnicalParameter.ParamType.STRING, dictCode = "GLZL")
    private String fuelType;


    @TechnicalParameter(key = "nameOfPressureParts", label = "受压部件名称", type = TechnicalParameter.ParamType.STRING, dictCode = "GLBJMC")
    private String nameOfPressureParts;


    @TechnicalParameter(key = "materialOfPressureParts", label = "受压部件材料", type = TechnicalParameter.ParamType.STRING)
    private String materialOfPressureParts;


    @TechnicalParameter(key = "wallThicknessOfPressureParts", label = "受压部件壁厚", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "mm")
    private BigDecimal wallThicknessOfPressureParts;


    @TechnicalParameter(key = "nonDestructiveTestingMethodsForPressureParts", label = "受压部件无损检测方法", type = TechnicalParameter.ParamType.STRING, dictCode = "GLWSJCFF")
    private String nonDestructiveTestingMethodsForPressureParts;


    @TechnicalParameter(key = "proportionOfNdtForPressureParts", label = "受压部件无损检测比例", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "%")
    private BigDecimal proportionOfNdtForPressureParts;


    @TechnicalParameter(key = "heatTreatmentTemperatureOfPressureParts", label = "受压部件热处理温度", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "℃")
    private BigDecimal heatTreatmentTemperatureOfPressureParts;


    @TechnicalParameter(key = "heatTreatmentTimeOfPressureParts", label = "受压部件热处理时间", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "h")
    private BigDecimal heatTreatmentTimeOfPressureParts;


    @TechnicalParameter(key = "hydrostaticTestMedium", label = "受压部件水（耐）压试验介质", type = TechnicalParameter.ParamType.STRING)
    private String hydrostaticTestMedium;


    @TechnicalParameter(key = "hydrostaticTestPressure", label = "受压部件水（耐）压试验压力", type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "MPa")
    private BigDecimal hydrostaticTestPressure;


    @TechnicalParameter(key = "combustionMode", label = "燃烧方式", type = TechnicalParameter.ParamType.STRING)
    private String combustionMode;

    @TechnicalParameter(key = "safetyValveVerificationReportNo", label = "安全阀效验报告编号", type = TechnicalParameter.ParamType.STRING)
    private String safetyValveVerificationReportNo;


    @TechnicalParameter(key = "safetyValveSettingPressure", label = "安全阀整定压力", type = TechnicalParameter.ParamType.STRING, unit = "Mpa")
    private String safetyValveSettingPressure;


    @TechnicalParameter(key = "waterTreatmentRegularInspectionReportNo", label = "水处理定期检验报告编号", type = TechnicalParameter.ParamType.STRING)
    private String waterTreatmentRegularInspectionReportNo;


    @TechnicalParameter(key = "waterTreatmentRegularInspectionResult", label = "水处理定期检验结论", type = TechnicalParameter.ParamType.STRING, dictCode = "SCLJL")
    private String waterTreatmentRegularInspectionResult;


    @TechnicalParameter(key = "energyEfficiencyTestReportNo", label = "能效测试报告编号", type = TechnicalParameter.ParamType.STRING)
    private String energyEfficiencyTestReportNo;
}
