package com.yeejoin.amos.boot.module.common.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.biz.service.impl.UserOperateLogServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@RequestMapping(value = "/user-operate-log")
@RequiredArgsConstructor
@Api(tags = "用户业务操作日志")
public class UserOperateLogController {

    private final UserOperateLogServiceImpl userOperateLogService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "操作日志查询")
    public ResponseModel<Page<JSONObject>> page(@RequestParam(value = "current") int current,
                                                @RequestParam(value = "size") int size,
                                                @RequestParam(required = false) Map<String, Object> params) {
        return ResponseHelper.buildResponse(userOperateLogService.page(current, size, new JSONObject(params)));

    }
}
