package com.yeejoin.amos.boot.module.cylinder.flc.api.enums;

import lombok.Getter;

/**
 * 设备状态枚举
 */
@Getter
public enum EquipmentStatusEnum {

    未安装("uninstalled", "未安装"),
    已安装("installed", "已安装");

    private String code;

    private String name;

    EquipmentStatusEnum(String code, String name) {
        this.name = name;
        this.code = code;
    }

    public static EquipmentStatusEnum getByCode(String code) {
        for (EquipmentStatusEnum statusEnum : EquipmentStatusEnum.values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
