package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.entity.SourceFile;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;


@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "LinkageUnitVo", description = "联动单位")
public class LinkageUnitVo extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "单位名称", index = 0)
    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ExcelIgnore
    @ApiModelProperty(value = "单位code")
    private String unitCode;

    @ExcelIgnore
    @ApiModelProperty(value = "父级单位id")
    private String parentId;

    @ExcelProperty(value = "服务类别", index = 1)
    @ExplicitConstraint(type = "LDDWLB", indexNum = 1, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ApiModelProperty(value = "服务类别")
    private String linkageUnitType;

    @ExcelIgnore
    @ApiModelProperty(value = "联动单位类别code")
    private String linkageUnitTypeCode;

    @ExcelIgnore
    @ApiModelProperty(value = "行政区划")
    private String administrativeDivisions;

    @ExcelIgnore
    @ApiModelProperty(value = "行政区划代码")
    private String administrativeDivisionsCode;

    @ExcelProperty(value = "地址", index = 2)
    @ApiModelProperty(value = "地址")
    private String address;
    @ExcelProperty(value = "经度", index = 3)
    @ApiModelProperty(value = "经度")
    private String longitude;
    @ExcelProperty(value = "纬度", index = 4)
    @ApiModelProperty(value = "纬度")
    private String latitude;
    @ExcelProperty(value = "协议开始日期", index = 5)
    @ApiModelProperty(value = "协议开始日期")
    private Date agreementStartDate;
    @ExcelProperty(value = "协议结束日期", index = 6)
    @ApiModelProperty(value = "协议结束日期")
    private Date agreementEndDate;
    @ExcelProperty(value = "应急联动单位类别", index = 7)
    @ExplicitConstraint(type = "YJLDDW", indexNum = 7, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ApiModelProperty(value = "应急联动单位类别")
    private String emergencyLinkageUnit;
    @ExcelIgnore
    @ApiModelProperty(value = "应急联动单位类别code")
    private String emergencyLinkageUnitCode;
    @ExcelProperty(value = "联系人", index = 8)
    @ApiModelProperty(value = "联系人 ")
    private String contactUser;
    @ExcelProperty(value = "联系人电话", index = 9)
    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;
    @ExcelIgnore
    @ApiModelProperty(value = "实例id")
    private Long instanceId;
    @ExcelIgnore
    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;
    @ExcelIgnore
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;
    @ExcelIgnore
    @ApiModelProperty(value = "是否在协议期 ")
    private String inAgreement;
    @ExcelProperty(value = "消防救援能力", index = 10)
    @ApiModelProperty(value = "消防救援能力")
    private String fireRescueCapability;
    @ExcelProperty(value = "职责_简要情况", index = 11)
    @ApiModelProperty(value = "职责_简要情况")
    private String responsibilitiesSituation;
    @ExcelProperty(value = "应急服务内容", index = 12)
    @ApiModelProperty(value = "应急服务内容")
    private String emergencyServiceContent;
    @ExcelProperty(value = "单位_简要情况", index = 13)
    @ApiModelProperty(value = "单位_简要情况")
    private String unitSituation;

    @ExcelIgnore
    @ApiModelProperty(value = "联动单位图片")
    private List<SourceFile> image;

    @ExcelIgnore
    @ApiModelProperty(value = "车辆数量")
    private String vehicleNumber;
    @ExcelIgnore
    @ApiModelProperty(value = "特岗人数")
    private String personNumber;
}
