package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.service;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

@Service
@RequiredArgsConstructor
@Slf4j
public class DocUpdateService {

    private final DocGenerateService docGenerateService;

    private final JyjcInspectionApplicationMapper repository;

    @Async
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void genDocAndUpdate(String appSeq) {
        log.info("异步生成报检申请表开始");
        String filePath = docGenerateService.generateDoc(appSeq);
        LambdaUpdateWrapper<JyjcInspectionApplication> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(JyjcInspectionApplication::getInspectAppUrl, filePath);
        updateWrapper.eq(BaseEntity::getSequenceNbr, appSeq);
        repository.update(null, updateWrapper);
        log.info("异步生成报检申请表结束");
    }
}
