package com.yeejoin.amos.boot.module.statistics.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 自定义筛选字段基础数据表
 *
 * @author system_generator
 * @date 2025-06-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_custom_filter")
public class TzsCustomFilter extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 是否快捷筛选（是：1，否：0）
     */
	@TableField("fast_filter")
    private String fastFilter;

    /**
     * 业务类型（设备：equip，企业：company，人员：person）
     */
	@TableField("filter_business_type")
    private String filterBusinessType;

    /**
     * 筛选字段code（对应业务数据筛选字段）
     */
	@TableField("filter_field_code")
    private String filterFieldCode;

    /**
     * 筛选字段名称（对应业务数据筛选字段名）
     */
	@TableField("filter_field_name")
    private String filterFieldName;

    /**
     * 筛选值code（对应业务数据筛选字段枚举值）
     */
	@TableField("filter_value_code")
    private String filterValueCode;

    /**
     * 筛选值名称（对应业务数据筛选字段枚举名称）
     */
	@TableField("filter_value_name")
    private String filterValueName;

    /**
     * 父节点Id
     */
	@TableField("parent_id")
    private String parentId;

    /**
     * 过滤类型（大于：gt，大于等于：ge，小于：lt，小于等于：le，介于：bt，等于：eq，不等于：ne，匹配：like，在列表中：in，不在列表中：not_in）
     */
	@TableField("operator_type")
    private String operatorType;

    /**
     * 备注1
     */
	@TableField("remark1")
    private String remark1;

    /**
     * 备注2
     */
	@TableField("remark2")
    private String remark2;

}
