package com.yeejoin.amos.boot.module.ymt.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ymt.api.common.MobileLoginParam;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.PageParam;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.ViewJgClaimMapper;
import com.yeejoin.amos.boot.module.ymt.api.service.ITzBaseEnterpriseInfoService;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.EquipmentCategoryServiceImpl;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.TzsAppService;
import com.yeejoin.amos.boot.module.ymt.flc.api.entity.RegUnitInfo;
import com.yeejoin.amos.boot.module.ymt.flc.api.mapper.RegUnitInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.PermissionModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@Slf4j
@Api(tags = "tzs小程序接口")
@RequestMapping(value = "/tzs-app")
public class TzsAppController {

    @Autowired
    TzsAppService appService;
    @Autowired
    private RegUnitInfoMapper regUnitInfoMapper;
    @Autowired
    private ViewJgClaimMapper viewJgClaimMapper;
    @Autowired
    ITzBaseEnterpriseInfoService iTzBaseEnterpriseInfoService;
    @Autowired
    private EquipmentCategoryServiceImpl equipmentCategoryService;
    private static final String LEVEL = "company";
    private static final String COMPANYPATH = "/company";
    private static final String JIANGUAN="/";

    /**
     * 小程序获取设备详情
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentInfo")
    @ApiOperation(httpMethod = "GET", value = "小程序获取设备详情", notes = "小程序获取设备详情")
    public ResponseModel<Object> getEquipmentInfo(String record) {
        return ResponseHelper.buildResponse(appService.getEquipmentInfo(record));
    }

    /**
     * 小程序获取设备详情-微信扫一扫
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipmentInfoWX")
    @ApiOperation(httpMethod = "GET", value = "小程序获取设备详情", notes = "小程序获取设备详情")
    public ResponseModel<Object> getEquipmentInfoWX(String record) {
        return ResponseHelper.buildResponse(appService.getEquipmentInfoWX(record));
    }


    /**
     * 根据监管码查询设备详情
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getEquipInfoBySuperviseCode")
    @ApiOperation(httpMethod = "GET", value = "根据监管码查询设备详情", notes = "根据监管码查询设备详情")
    public ResponseModel<Object> getEquipInfoBySuperviseCode(String supervisoryCode) {
        return ResponseHelper.buildResponse(appService.getEquipInfoBySuperviseCode(supervisoryCode));
    }

//    /**
//     * 登录
//     * @return
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
//    @PostMapping(value = "/mobile/login")
//    @ApiOperation(httpMethod = "POST", value = "小程序登录", notes = "小程序登录")
//    public ResponseModel<Map<String, Object>> login(@RequestBody MobileLoginParam param) {
//        return ResponseHelper.buildResponse(appService.login(param));
//    }

  /**
   * 小程序企业详情
   * */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/details", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "小程序企业详情", notes = "小程序企业详情")
    public ResponseModel<IPage<TzBaseEnterpriseInfoDto>> pageInfo( String unitCode) {
        PageParam pageParam = new PageParam();
        LambdaQueryWrapper<TzBaseEnterpriseInfo> objectLambdaQueryWrapper = new LambdaQueryWrapper<>();
        objectLambdaQueryWrapper.eq(!ValidationUtil.isEmpty(unitCode),TzBaseEnterpriseInfo::getUseCode,unitCode);
        TzBaseEnterpriseInfo neInfo = iTzBaseEnterpriseInfoService.getOne(objectLambdaQueryWrapper, true);
        return ResponseHelper.buildResponse(iTzBaseEnterpriseInfoService.page(pageParam, neInfo.getUseUnit()));
    }

    /**
     * 小程序菜单权限
     * */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/permission/tree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "小程序菜单权限", notes = "小程序菜单权限")
    public FeignClientResult<Collection<PermissionModel>> tree(HttpServletRequest http,@RequestParam(value = "most",required = false)String most) {
        FeignClientResult<Collection<PermissionModel>> app=new FeignClientResult<Collection<PermissionModel>>();
        if (ValidationUtil.isEmpty(most)) {
            //根据当前登录人的公司是企业还是监管来过滤
            List<JSONObject> objectList = equipmentCategoryService.getCompanyType();
            List<JSONObject> total = objectList.stream().filter(item -> !LEVEL.equals(item.getString("level"))).collect(Collectors.toList());
                if (total.size()==0) {
                    //企业
                    app = Privilege.permissionClient.queryPermissionTree("APP", null, null, COMPANYPATH, null);
                } else {
                    //监管
                    app = Privilege.permissionClient.queryPermissionTree("APP", null, null, JIANGUAN, null);
                }
        }else  {
                //更多应用
            app = Privilege.permissionClient.queryPermissionTree("APP", null, null, most, null);

        }

        return app;
    }

    //修改密码
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{userId}/password", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改密码", notes = "修改密码")
    public ResponseModel<Boolean> updatePassword( @PathVariable("userId")  String userId ,@RequestBody  AgencyUserModel AgencyUserModel) {
        Boolean result =false;
        if ( ValidationUtil.isEmpty(userId) ||
                ValidationUtil.isEmpty(AgencyUserModel.getOriginalPassword()) ||
                ValidationUtil.isEmpty(AgencyUserModel.getRePassword()) ||
                ValidationUtil.isEmpty(AgencyUserModel.getPassword()) ) {
            log.error("用户信息不能为空");
           return ResponseHelper.buildResponse(result);
        }
        if (!AgencyUserModel.getRePassword().equals(AgencyUserModel.getPassword())) {
            log.error("两次密码不一致");
            return ResponseHelper.buildResponse(result);
        }
        //平台修改
        AgencyUserModel.setUserId(userId);
        FeignClientResult<AgencyUserModel> agencyUserModelFeignClientResult = Privilege.agencyUserClient.modifyPassword(userId, AgencyUserModel);
        if ( agencyUserModelFeignClientResult.getStatus() !=200  ) {
            log.error("Privilege远程调用失败");
            return ResponseHelper.buildResponse(result);
        }
        if ( ValidationUtil.isEmpty(agencyUserModelFeignClientResult.getResult()) || ValidationUtil.isEmpty(agencyUserModelFeignClientResult.getResult().getUserId())) {
            log.error("平台修改失败");
            return ResponseHelper.buildResponse(result);

        }
        //走业务修改
        LambdaQueryWrapper<RegUnitInfo> objectLambdaQueryWrapper = new LambdaQueryWrapper<>();
        objectLambdaQueryWrapper.eq(RegUnitInfo::getAdminUserId,agencyUserModelFeignClientResult.getResult().getUserId());
        RegUnitInfo regUnitInfo = new RegUnitInfo();
        regUnitInfo.setAdminLoginPwd(AgencyUserModel.getRePassword());
        int update = regUnitInfoMapper.update(regUnitInfo, objectLambdaQueryWrapper);
        if (update == 0) {
            log.error("业务更新失败");
            return ResponseHelper.buildResponse(result);
        }
        result=true;

        return ResponseHelper.buildResponse(result);
    }


    //扫一扫功能通过监管查询SEQUENCE_NBR
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/supervisoryCode", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "扫一扫功能通过监管查询SEQUENCE_NBR", notes = "扫一扫功能通过监管查询SEQUENCE_NBR")
    public ResponseModel<String> supervisoryCode(String code) {
        String sequenceNbr = viewJgClaimMapper.supervisoryCode(code);
        return ResponseHelper.buildResponse(sequenceNbr);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @RequestMapping(value = "/wxUserLogin", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "微信授权登陆", notes = "微信授权登陆")
    public ResponseModel<JSONObject> wxUserLogin(@RequestBody JSONObject  wx) {
        return ResponseHelper.buildResponse(appService.wxUserLogin(wx));
    }

    //企业的设备总数统计
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "企业的认领设备总数", notes = "企业的认领设备总数")
    @GetMapping(value = "/equipmentCount")
    public ResponseModel<Object> equipClaimOverview(String unitCode) {
        return ResponseHelper.buildResponse(appService.equipmentCount(unitCode));
    }

    //设备列表
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "设备列表", notes = "设备列表")
    @GetMapping(value = "/getTable")
    public ResponseModel<Page<Map<String,Object>>> getTable(@RequestParam Map<String,Object> map) {
        return ResponseHelper.buildResponse(appService.getTable(map));
    }

    //行政区划树

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "行政区划code", notes = "行政区划code")
    @GetMapping(value = "/getRegionName")
    public ResponseModel<JSONArray> getRegionName() {
        return ResponseHelper.buildResponse(appService.getRegionName());
    }


    }
