package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory;

import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.support.DocGenerator;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.support.SupportableDocGenerator;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.wrapper.DocGeneratorWrapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Service
@RequiredArgsConstructor
public class DocGeneratorFactory {

    private final Map<String, DocGenerator> docGenerators = new ConcurrentHashMap<>();

    private final List<SupportableDocGenerator> factories;

    public DocGenerator getGenerator(String equList, String equCategory, String equDefine) {
        return docGenerators.computeIfAbsent(equList, k ->
                new DocGeneratorWrapper(
                        factories.stream()
                                .filter(s -> s.support(equList, equCategory, equDefine))
                                .findFirst()
                                .orElseThrow(() -> new UnsupportedOperationException(String.format("No generator found for type: %s (list=%s, define=%s)",
                                        equCategory, equList, equDefine))))
        );
    }
}
