package com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.strategy;

import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionHistory;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.factory.support.SupportableDocGenerator;
import com.yeejoin.amos.boot.module.jyjc.biz.file.inspectapp.strategy.common.InspectAppDocCmService;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionApplicationServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionHistoryServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.util.WordTemplateUtils;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
@RequiredArgsConstructor
public class PipelineDocGeneratorStrategy implements SupportableDocGenerator {

    private final JyjcInspectionApplicationServiceImpl jyjcInspectionApplicationService;

    private final InspectAppDocCmService appDocCmService;

    private final JyjcInspectionHistoryServiceImpl inspectionHistoryService;

    @Override
    public boolean support(String equList, String equCategory, String equDefine) {
        return EquipmentClassifityEnum.YLGD.getCode().equals(equList);
    }

    @Override
    public String generate(String appId) {
        Map<String, Object> params = appDocCmService.getBaseInFo(appId);
        JyjcInspectionApplication inspectionApplication = jyjcInspectionApplicationService.getBaseMapper().selectById(appId);
        this.setPipelineInfo(params, inspectionApplication);
        return this.generatePdfAndUpload(params);
    }

    private void setPipelineInfo(Map<String, Object> params, JyjcInspectionApplication inspectionApplication) {
        if (inspectionApplication.getStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()))) {
            JyjcInspectionHistory inspectionHistory = inspectionHistoryService.getBySSeq(inspectionApplication.getSequenceNbr());
            if (inspectionHistory != null) {
                // 新报检单记录历史数据的逻辑
                params.put("pipelines", inspectionHistory.getHistoryData().get("equip"));
                params.put("numberOfEquip", inspectionHistory.getHistoryData().get("pipelineLength"));
            } else {
                List<Map<String, Object>> pipelines = jyjcInspectionApplicationService.getPipelines(inspectionApplication);
                params.put("pipelines", pipelines);
                params.put("numberOfEquip", JyjcInspectionApplicationServiceImpl.calTotalLength(pipelines));
            }
        } else {
            List<Map<String, Object>> pipelines = jyjcInspectionApplicationService.getPipelines(inspectionApplication);
            params.put("pipelines", pipelines);
            params.put("numberOfEquip", JyjcInspectionApplicationServiceImpl.calTotalLength(pipelines));
        }
    }

    private String generatePdfAndUpload(Map<String, Object> formData) {
        String wordPath = "inspect-app-pipeline.ftl";
        String fileName = "检验检测报检申请受理单";
        File pdfFile = null;
        try {
            // 填充模板,  word转pdf
            pdfFile = WordTemplateUtils.wordToPdf(fileName, wordPath, formData);
            // 上传文档到文件服务器
            return WordTemplateUtils.uploadFile(pdfFile, "upload/tzs/pdf/inspectApp");
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            try {
                if (pdfFile != null) {
                    Files.deleteIfExists(pdfFile.toPath());
                }
            } catch (Exception e) {
                log.error("文件找不到，删除失败：{}", e.getMessage());
            }
        }
    }
}
