package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.constant.TZSCommonConstant;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionHistory;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.enums.PersonTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcBaseMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.InstanceRuntimeData;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultModel;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzsUserInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class CommonServiceImpl {

    @Value("${jyjc.user-post:6615}")
    private String jyjcUserPost;

    @Value("${jyjc.user-post:6616}")
    private String jyjcBizUserPost;

    @Value("${jy.user-post:66151}")
    private String jyUserPost;

    @Value("${jc.user-post:66152}")
    private String jcUserPost;

    @Value("${jyjc.charge.user-post:6667}")
    private String chargeUserPost;

    private final Map<String, String> CODE_NAME_MAP = new ConcurrentHashMap<>();

    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsUserInfoMapper userInfoMapper;

    @Autowired
    TzBaseEnterpriseInfoMapper enterpriseInfoMapper;

    @Autowired
    RedissonClient redissonClient;

    @Autowired
    JyjcBaseMapper jyjcBaseMapper;

    @Autowired
    private DataDictionaryServiceImpl dictionaryService;

    @Resource
    private JyjcInspectionHistoryServiceImpl inspectionHistoryService;

    @Resource
    private ESEquipmentCategory esEquipmentCategory;


    /**
     * 可发起单位的单位类型（角色与单位类型已绑定，在业务系统增加的账号不会出现角色与的单位类型不匹配场景）
     */
    private final static String[] applyIdentityDefine = {"使用单位", "安装改造维修单位"};
    /**
     * 可进行检验检测申请接收的单位类型，在业务系统增加的账号不会出现角色与的单位类型不匹配场景
     */
    private final static String[] receiveIdentityDefine = {"检验机构", "检测机构"};


    /**
     * @return ReginParams
     * @description 获取当前用户注册信息
     */
    ReginParams getReginParamsOfCurrentUser() {
        return JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
    }

    public List<TzsUserInfo> getUserInfosByUnitCode(String unitCode) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        userInfoQueryWrapper.like(TzsUserInfo::getPost, jyjcUserPost);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        userInfoQueryWrapper.select(
                BaseEntity::getSequenceNbr,
                TzsUserInfo::getName,
                TzsUserInfo::getCertificateNum,
                TzsUserInfo::getPost,
                TzsUserInfo::getAmosUserId,
                TzsUserInfo::getPhone);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }

    public List<TzsUserInfo> getUserListByUnitCodeAndPost(String unitCode, String personType) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.eq(TzsUserInfo::getUnitCode, unitCode);
        this.castPersonType2Post(userInfoQueryWrapper, personType);
        userInfoQueryWrapper.eq(BaseEntity::getIsDelete, false);
        userInfoQueryWrapper.select(TzsUserInfo::getPost, TzsUserInfo::getPhone, TzsUserInfo::getName, TzsUserInfo::getInnerPersonCode, BaseEntity::getSequenceNbr);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }


    public void castPersonType2Post(LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper, String personType) {

        if (personType.contains(PersonTypeEnum.jc.name()) && personType.contains(PersonTypeEnum.jy.name()) && personType.contains(PersonTypeEnum.charge.name())) {
            userInfoQueryWrapper.and(w -> w.like(TzsUserInfo::getPost, jyUserPost).or().like(TzsUserInfo::getPost, jcUserPost).or().like(TzsUserInfo::getPost, chargeUserPost));
            return;
        }
        if (personType.contains(PersonTypeEnum.jc.name()) && personType.contains(PersonTypeEnum.jy.name())) {
            userInfoQueryWrapper.and(w -> w.like(TzsUserInfo::getPost, jyUserPost).or().like(TzsUserInfo::getPost, jcUserPost));
            return;
        }
        if (personType.equals(PersonTypeEnum.jy.name())) {
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jyUserPost);
            return;
        }
        if (personType.equals(PersonTypeEnum.jc.name())) {
            userInfoQueryWrapper.like(TzsUserInfo::getPost, jcUserPost);
        }
    }

    public List<TzsUserInfo> getBizUserInfosByUnitCode(String unitCode) {
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.eq("unit_code", unitCode);
        userInfoQueryWrapper.like("post", jyjcBizUserPost);
        userInfoQueryWrapper.isNotNull("amos_user_id");
        userInfoQueryWrapper.eq("is_delete", false);
        List<TzsUserInfo> userInfos = userInfoMapper.selectList(userInfoQueryWrapper);
        return userInfos;
    }

    public List<TzsUserInfo> getUserPhonesByPersonCode(String personCode) {
        List<String> ids = StrUtil.split(personCode, ",");
        QueryWrapper userInfoQueryWrapper = new QueryWrapper<>();
        userInfoQueryWrapper.in("sequence_nbr", ids);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }


    public List<TzBaseEnterpriseInfoDto> getInspectionUnitList(String openBizType) {
        return enterpriseInfoMapper.getInspectionUnitList(openBizType);
    }

    public TzBaseEnterpriseInfo getInspectionUnitBySequenceNbr(Long sequenceNbr) {
        return enterpriseInfoMapper.selectBySeq(sequenceNbr);
    }


    /**
     * 执行流程时前置校验是否已经执行
     *
     * @param taskId     任务id
     * @param instanceId 实例id
     */
    public void checkForExecuteFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前流程已经被转办给其他人或者页面按钮问题导致的权限未控制
        String nextExecuteUserIds = instanceRuntimeData.getNextExecuteUserIds();
        if (!nextExecuteUserIds.contains(RequestContext.getExeUserId())) {
            throw new BadRequest("当前登录人无执行权限！");
        }

    }

    private InstanceRuntimeData getInstanceRuntimeData(String instanceId) {
        RBucket<InstanceRuntimeData> rBucket = redissonClient.getBucket(buildJcInstanceDataKey(instanceId));
        return rBucket.get();
    }

    private String buildJcInstanceDataKey(String instanceId) {
        return "JC_INSTANCE_DATA:" + instanceId;
    }

    public static String buildJcExecuteLockKey(String instanceId) {
        return "JC_INSTANCE_LOCK:" + instanceId;
    }


    /**
     * 最新流程数据缓存
     *
     * @param instanceId   实例id
     * @param instanceData 流程数据
     */
    public void saveExecuteFlowData2Redis(String instanceId, InstanceRuntimeData instanceData) {
        redissonClient.getBucket(buildJcInstanceDataKey(instanceId)).set(instanceData);
    }

    /**
     * 根据流程状态name 获取流程状态code
     *
     * @param name 流程状态name
     * @return 流程状态code
     */
    public Integer getDictionaryCodeByName(String name) {
        List<DataDictionary> jggzzz = dictionaryService.getByType("JGGZZZ");
        for (DataDictionary item : jggzzz) {
            if (item.getName().equals(name)) {
                return Integer.parseInt(item.getCode());
            }
        }
        return null;
    }

    public void saveOrUpdateHistory(String type, JSONObject json, Long currentDocumentId) {
        JyjcInspectionHistory jyjcInspectionHistory = new JyjcInspectionHistory();
        LambdaQueryWrapper<JyjcInspectionHistory> lambda = new QueryWrapper<JyjcInspectionHistory>().lambda();
        lambda.eq(JyjcInspectionHistory::getSSeq, currentDocumentId);
        Integer integer = inspectionHistoryService.getBaseMapper().selectCount(lambda);
        jyjcInspectionHistory.setHistoryData(json);
        if (integer > 0) {
            inspectionHistoryService.update(jyjcInspectionHistory, lambda);
        } else {
            jyjcInspectionHistory.setSType(type);
            jyjcInspectionHistory.setSSeq(currentDocumentId);
            inspectionHistoryService.save(jyjcInspectionHistory);
        }
    }


    /**
     * 撤回时校验流程是否已经执行
     *
     * @param taskId     前端业务上送任务id
     * @param instanceId 实例id
     */
    public void checkForRevocationFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 前端页面上送任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        if (!instanceRuntimeData.getPromoter().equals(RequestContext.getExeUserId())) {
            throw new BadRequest("无权限执行该任务");
        }
    }

    public List<AgencyUserModel> getAmosUseListByCompanyCode(String unitCode) {
        CompanyModel companyModel = jyjcBaseMapper.selectOneCompanyByCode(unitCode);
        FeignClientResult<List<AgencyUserModel>> result = Privilege.agencyUserClient.queryByCompanyId(companyModel.getSequenceNbr(), null, null, false);
        return result.getResult();
    }

    /**
     * 排序  ：页面列表排序功能支持，将 "字段,ascend" 或 "字段,descend" 转化为对应JSONObject
     *
     * @param sort "字段,ascend" 或 "字段,descend"
     * @return JSONObject
     */
    public SortVo sortFieldConversion(String sort) {
        Optional<String> optionalSort = Optional.ofNullable(sort);
        Optional<SortVo> optionalSortMap = optionalSort.filter(s -> !s.isEmpty())
                .map(s -> {
                    String[] sortParts = s.split(",");
                    if (sortParts.length == 2) {
                        String field = sortParts[0];
                        String sortSituation = sortParts[1].contains("asc") ? "ASC" : "DESC";
                        return SortVo.builder()
                                .field(convertToUnderline(field))
                                .sortType(sortSituation)
                                .build();
                    }
                    return null;
                });
        return optionalSortMap.orElse(null);
    }

    /**
     * 驼峰转下划线
     *
     * @param str
     * @return
     */
    public static String convertToUnderline(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_").append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    /**
     * 数据质量等级枚举转名称描述
     *
     * @param dataQualityScore 等级枚举
     * @param isIntoManagement 是否纳管
     * @return 名称描述
     */
    public String castDataQualityScore2Name(String dataQualityScore, Boolean isIntoManagement) {
        DataDictionary dataDictionary = dictionaryService.getByCode("DATA_QUALITY_SCORE", dataQualityScore);
        String name = Optional.ofNullable(dataDictionary).map(DataDictionary::getName).orElse(null);
        return name == null ? (isIntoManagement == null || !isIntoManagement) ? "二类" : "一类" : name;
    }


    public String getRegionName(String regionCode) {
        return regionCode != null ? CODE_NAME_MAP.computeIfAbsent(regionCode, (k) -> {
            List<LinkedHashMap> list1 = (List<LinkedHashMap>) redisUtils.get(TZSCommonConstant.PROVINCE);
            List<LinkedHashMap> list2 = (List<LinkedHashMap>) redisUtils.get(TZSCommonConstant.CITY);
            List<LinkedHashMap> list3 = (List<LinkedHashMap>) redisUtils.get(TZSCommonConstant.REGION);
            List<LinkedHashMap> list4 = (List<LinkedHashMap>) redisUtils.get(TZSCommonConstant.STREET);
            Optional<LinkedHashMap> op = Stream.of(list1, list2, list3, list4).flatMap(Collection::stream).filter(item -> String.valueOf(item.get("regionCode")).trim().equals(regionCode)).findFirst();
            return op.map(linkedHashMap -> linkedHashMap.get("regionName").toString()).orElse("");
        }) : "";
    }


    public static String getCompanyLevel(CompanyBo company) {
        String companyLevel = "";
        if (company.getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            companyLevel = BaseController.COMPANY_TYPE_COMPANY;
        } else {
            companyLevel = BaseController.COMPANY_TYPE_SUPERVISION;
        }
        return companyLevel;
    }

    public String getDictName(List<String> dictTypes, String dictKey) {
        if (StringUtils.isEmpty(dictKey)) {
            return "";
        }
        List<DataDictionary> dataDictionaries = dictionaryService.list(new LambdaQueryWrapper<DataDictionary>().in(DataDictionary::getType, dictTypes).select(BaseEntity::getSequenceNbr, DataDictionary::getName, DataDictionary::getCode));
        return dataDictionaries.stream().filter(d -> d.getCode().equals(dictKey)).findFirst().map(DataDictionary::getName).orElse("");
    }

    public static String getCompanyIdentityByType(String companyType) {
        boolean isApplyIdentityMatch = false;
        boolean isReceiveIdentityMatch = false;
        if (Arrays.stream(applyIdentityDefine).anyMatch(companyType::contains)) {
            isApplyIdentityMatch = true;
        }
        if (Arrays.stream(receiveIdentityDefine).anyMatch(companyType::contains)) {
            isReceiveIdentityMatch = true;
        }
        if (isApplyIdentityMatch && !isReceiveIdentityMatch) {
            return "apply";
        }
        if (!isApplyIdentityMatch && isReceiveIdentityMatch) {
            return "receive";
        }
        return "no";
    }

    public void updateEquipNextInspectDate(JyjcInspectionResultModel model, String record) {
        updateEsInspectDate(record, model.getNextInspectionDate());
    }

    public void updateEquipNextInspectDate(JyjcInspectionResult model, String record) {
        updateEsInspectDate(record, model.getNextInspectionDate());
    }

    private void updateEsInspectDate(String record, Date nextInspectionDate) {
        if (nextInspectionDate != null) {
            Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
            if (optional.isPresent()) {
                ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
                esEquipmentCategoryDto.setNEXT_INSPECT_DATE(nextInspectionDate.getTime());
                esEquipmentCategory.save(esEquipmentCategoryDto);
            }
        }
    }

    public void buildInspectInfo(JyjcInspectionResultModel model, IdxBizJgInspectionDetectionInfo info, JyjcInspectionResultAttachment jybgFile, String record) {
        info.setInspectOrgName(model.getInspectionUnitName());
        info.setInspectType(model.getInspectionType());
        info.setRecord(record);
        info.setResultSeq(model.getSequenceNbr() + "");
        info.setInspectDate(model.getInspectionDate());
        info.setInspectStaffCode(model.getInspector());
        info.setInspectStaff(getInspectUserName(model.getInspector()));
        info.setInspectReport(jybgFile.getAttachmentUrl());
        info.setInspectConclusion(model.getInspectionConclusion());
        info.setProblemRemark(model.getNonConformance());
        info.setNextInspectDate(model.getNextInspectionDate());
        info.setSequenceCode(record);
        info.setInspectOrgCode(model.getInspectionUnitCode());
        info.setInspectReportNo(model.getResultNo());
        info.setRecDate(new Date());
    }

    public void buildInspectInfo(JyjcInspectionResult model, IdxBizJgInspectionDetectionInfo info, JyjcInspectionResultAttachment jybgFile, String record) {
        info.setInspectOrgName(model.getInspectionUnitName());
        info.setInspectType(model.getInspectionType());
        info.setRecord(record);
        info.setInspectDate(model.getInspectionDate());
        info.setInspectStaffCode(model.getInspector());
        info.setInspectStaff(getInspectUserName(model.getInspector()));
        info.setInspectReport(jybgFile.getAttachmentUrl());
        info.setInspectConclusion(model.getInspectionConclusion());
        info.setResultSeq(model.getSequenceNbr() + "");
        info.setProblemRemark(model.getNonConformance());
        info.setNextInspectDate(model.getNextInspectionDate());
        info.setSequenceCode(record);
        info.setInspectOrgCode(model.getInspectionUnitCode());
        info.setInspectReportNo(model.getResultNo());
        info.setRecDate(new Date());
    }


    public String getInspectUserName(String inspector) {
        if(StringUtils.isNotBlank(inspector)) {
            List<TzsUserInfo> userInfos = this.getUserInfosByIds(inspector);
            return userInfos.stream().map(TzsUserInfo::getName).collect(Collectors.joining(","));
        }
        return "";
    }

    private List<TzsUserInfo> getUserInfosByIds(String inspector) {
        LambdaQueryWrapper<TzsUserInfo> userInfoQueryWrapper = new LambdaQueryWrapper<>();
        userInfoQueryWrapper.in(TzsUserInfo::getSequenceNbr, Arrays.asList(inspector.split(",")));
        userInfoQueryWrapper.select(BaseEntity::getSequenceNbr, TzsUserInfo::getName);
        return userInfoMapper.selectList(userInfoQueryWrapper);
    }

    /**
     * 兼容个人类型6600_
     *
     * @param company 身份
     * @return 不带证件类型的公司code
     */
    public static String getUnitCode(CompanyBo company) {
        String unitCode;
        unitCode = company.getCompanyCode();
        unitCode = unitCode.contains("_") ? unitCode.substring(unitCode.indexOf("_") + 1) : unitCode;
        return unitCode;
    }
}
