package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.*;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.*;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IAlarmInfoDetailService;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.FanHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.FanWaringRecordMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.PvHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.PvWaringRecordMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvWarningRecord;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class AlarmInfoDetailServiceImpl implements IAlarmInfoDetailService {
    @Autowired
    IndicatorDataMapper indicatorDataMapper;
    @Autowired
    IdxBizFanWarningRecordMapper idxBizFanWarningRecordMapper;

    @Autowired
    IdxBizPvWarningRecordMapper idxBizPvWarningRecordMapper;
    @Autowired
    IdxBizFanHealthIndexMapper idxBizFanHealthIndexMapper;

    @Autowired
    IdxBizPvHealthIndexMapper idxBizPvHealthIndexMapper;
    @Autowired
    IdxBizFanPointVarCentralValueMapper idxBizFanPointVarCentralValueMapper;

    @Autowired
    IdxBizPvPointVarCentralValueMapper idxBizPvPointVarCentralValueMapper;
    @Autowired
    IdxBizFanPointProcessVariableClassificationMapper idxBizFanPointProcessVariableClassificationMapper;
    @Autowired
    IdxBizPvPointProcessVariableClassificationMapper idxBizPvPointProcessVariableClassificationMapper;
    @Autowired
    IdxBizFanPointVarCorrelationMapper idxBizFanPointVarCorrelationMapper;
    @Autowired
    IdxBizPvPointVarCorrelationMapper idxBizPvPointVarCorrelationMapper;

    @Autowired
    private FanWaringRecordMapper fanWaringRecordMapper;


    @Autowired
    private PvWaringRecordMapper pvWaringRecordMapper;

    @Autowired
    FanHealthIndexMapper fanHealthIndexMapper;


    @Autowired
    PvHealthIndexMapper pvHealthIndexMapper;


    @Override
    public Map<String, Object> getAlramInfoDetailOfFan(String id) {
        Map<String, Object> result = new HashMap<>();
        FanWarningRecord idxBizFanWarningRecord = fanWaringRecordMapper.getInfoByTs(Long.valueOf(id));
        //获取告警信息
        result.put("warningInfo", getFanAlarmInfoMap(idxBizFanWarningRecord));
        //获取工况组合来源
        result.put("sourceInfo", getSourceInfoMapFan(idxBizFanWarningRecord));
        // 获取预警趋势
        HashMap<String, Object> alarmTrendAndAlarmAbnormalityListResult = getFanAlarmTrendAndAlarmAbnormalityList(idxBizFanWarningRecord);
        result.put("alarmTrend", alarmTrendAndAlarmAbnormalityListResult.get("alarmTrend"));
        result.put("alarmAbnormalityList", alarmTrendAndAlarmAbnormalityListResult.get("alarmAbnormalityList"));
        String startTime = (String) alarmTrendAndAlarmAbnormalityListResult.get("startTime");
        String endTime = (String) alarmTrendAndAlarmAbnormalityListResult.get("endTime");
        //----健康指数来源
            List<IdxBizFanPointVarCentralValue> idxBizFanPointVarCentralValueList = idxBizFanPointVarCentralValueMapper
                .selectList(new QueryWrapper<IdxBizFanPointVarCentralValue>()
                        .eq("ANALYSIS_POINT_ID", idxBizFanWarningRecord.getAnalysisPointId()));
        IdxBizFanPointVarCentralValue idxBizFanPointVarCentralValue = new IdxBizFanPointVarCentralValue();
        if (idxBizFanPointVarCentralValueList.size() <= 0) {
            result.put("healthPointInfo", new HashMap<>());
            result.put("currentValue", new HashMap<>());
            result.put("trainValue", new HashMap<>());
            return result;
        }
        idxBizFanPointVarCentralValue = idxBizFanPointVarCentralValueList.get(0);
        handlerIdxBizFanPointVarCentralValue(idxBizFanPointVarCentralValueList);
        //健康指数来源测点信息
        result.put("healthPointInfo", getHealthPointInfoFan(idxBizFanPointVarCentralValue));
        HashMap<String, Object> currentValueAndTrainValueMap = getCurrentValueAndTrainValueInfoFan(idxBizFanPointVarCentralValue, startTime, endTime, idxBizFanPointVarCentralValueList);
        //当前值
        result.put("currentValue", currentValueAndTrainValueMap.get("currentValue"));
        //训练值
        result.put("trainValue", currentValueAndTrainValueMap.get("trainValue"));
        return result;
    }

    @Override
    public Map<String, Object> getAlramInfoDetailOfPv(String id) {
        Map<String, Object> result = new HashMap<>();
        PvWarningRecord idxBizPvWarningRecord = pvWaringRecordMapper.getInfoByTs(Long.valueOf(id));
        //告警信息
        result.put("warningInfo", getPvAlarmInfoMap(idxBizPvWarningRecord));
        //---------------工况组合来源
        result.put("sourceInfo", getSourceInfoMapPv(idxBizPvWarningRecord));
        // -----------预警趋势
        HashMap<String, Object> alarmTrendAndAlarmAbnormalityListResult = getPvAlarmTrendAndAlarmAbnormalityList(idxBizPvWarningRecord);
        result.put("alarmTrend", alarmTrendAndAlarmAbnormalityListResult.get("alarmTrend"));
        result.put("alarmAbnormalityList", alarmTrendAndAlarmAbnormalityListResult.get("alarmAbnormalityList"));
        String startTime = (String) alarmTrendAndAlarmAbnormalityListResult.get("startTime");
        String endTime = (String) alarmTrendAndAlarmAbnormalityListResult.get("endTime");
        //----健康指数来源
        List<IdxBizPvPointVarCentralValue> idxBizPvPointVarCentralValueList = idxBizPvPointVarCentralValueMapper
                .selectList(new QueryWrapper<IdxBizPvPointVarCentralValue>()
                        .eq("ANALYSIS_POINT_ID", idxBizPvWarningRecord.getAnalysisPointId()));
        IdxBizPvPointVarCentralValue idxBizPvPointVarCentralValue = new IdxBizPvPointVarCentralValue();
        if (idxBizPvPointVarCentralValueList.size() <= 0) {
            result.put("healthPointInfo", new HashMap<>());
            result.put("currentValue", new HashMap<>());
            result.put("trainValue", new HashMap<>());
            return result;
        }
        idxBizPvPointVarCentralValue = idxBizPvPointVarCentralValueList.get(0);
        handlerIdxBizPvPointVarCentralValue(idxBizPvPointVarCentralValueList);
        //健康指数来源测点信息
        result.put("healthPointInfo", getHealthPointInfoPv(idxBizPvPointVarCentralValue));
        HashMap<String, Object> currentValueAndTrainValueMap = getCurrentValueAndTrainValueInfoPv(idxBizPvPointVarCentralValue, startTime, endTime, idxBizPvPointVarCentralValueList);
        //当前值
        result.put("currentValue", currentValueAndTrainValueMap.get("currentValue"));
        //训练值
        result.put("trainValue", currentValueAndTrainValueMap.get("trainValue"));
        return result;
    }

    /**
     *  获取告风机警信息
     * @param idxBizFanWarningRecord
     * @return 告警信息
     */
    public HashMap<String, String> getFanAlarmInfoMap(FanWarningRecord idxBizFanWarningRecord) {

        HashMap<String, String> alarmInfoMap = new HashMap<>();
        //测点名称
        alarmInfoMap.put("pointName", idxBizFanWarningRecord.getPointName());
        //告警周期
        alarmInfoMap.put("waringPeriod", CommonConstans.waringPeriodStatus.get(idxBizFanWarningRecord.getWarningPeriod()));
        //告警时间
        alarmInfoMap.put("waringTime", DateUtil.format(DateUtil.parse(idxBizFanWarningRecord.getRecDate(), DatePattern.NORM_DATETIME_PATTERN), CommonConstans.waringPeriodDateFormate.get(idxBizFanWarningRecord.getWarningPeriod())));
        //预警等级
        alarmInfoMap.put("waringLevel", idxBizFanWarningRecord.getWarningName());
        //预警触发规则
        alarmInfoMap.put("waringRule", idxBizFanWarningRecord.getContent());
        return alarmInfoMap;
    }

    /**
     * 获取光伏告警信息
     * @param idxBizPvWarningRecord
     * @return 告警信息
     */
    public HashMap<String, String> getPvAlarmInfoMap(PvWarningRecord idxBizPvWarningRecord) {

        HashMap<String, String> alarmInfoMap = new HashMap<>();
        //测点名称
        alarmInfoMap.put("pointName", idxBizPvWarningRecord.getPointName());
        //告警周期
        alarmInfoMap.put("waringPeriod", CommonConstans.waringPeriodStatus.get(idxBizPvWarningRecord.getWarningPeriod()));
        //告警时间
        alarmInfoMap.put("waringTime", DateUtil.format(DateUtil.parse(idxBizPvWarningRecord.getRecDate(), DatePattern.NORM_DATETIME_PATTERN), CommonConstans.waringPeriodDateFormate.get(idxBizPvWarningRecord.getWarningPeriod())));
        //预警等级
        alarmInfoMap.put("waringLevel", idxBizPvWarningRecord.getWarningName());
        //预警触发规则
        alarmInfoMap.put("waringRule", idxBizPvWarningRecord.getContent());
        return alarmInfoMap;
    }

    /**
     *  获取风机趋势数据、异常度数据、开始时间、结束时间
     * @param idxBizFanWarningRecord
     * @return
     */
    public HashMap<String, Object> getFanAlarmTrendAndAlarmAbnormalityList(FanWarningRecord idxBizFanWarningRecord) {
        HashMap<String, Object> result = new HashMap<>();
        HashMap<String, Object> alarmTrendMap = new HashMap<>();
        HashMap<String,Object> maxValueAndWaringCycle = getWaringCycleAndMaxValueByWaring(idxBizFanWarningRecord.getWarningPeriod(),idxBizFanWarningRecord.getContent(),idxBizFanWarningRecord.getPointName());
        Integer warningCycle = Integer.valueOf(maxValueAndWaringCycle.get("warningCycle").toString());
        alarmTrendMap.put("maxValue", maxValueAndWaringCycle.get("maxValue"));
        alarmTrendMap.put("warningCycle", warningCycle);
        List<HashMap<String, String>> alarmAbnormalityList = new ArrayList<>();
        List<FanHealthIndex> idxBizFanHealthIndexList = fanHealthIndexMapper.selectList(new QueryWrapper<FanHealthIndex>()
                .eq("gateway_id", idxBizFanWarningRecord.getGatewayId())
                .eq("index_address", idxBizFanWarningRecord.getIndexAddress())
                .eq("analysis_type", idxBizFanWarningRecord.getWarningPeriod())
                //时区减8小时  时间加1分钟
                .le("ts", DateUtil.offsetMinute(DateUtil.parse(idxBizFanWarningRecord.getRecDate(), DatePattern.NORM_DATETIME_PATTERN), -479))
                .orderByDesc("ts")
                .last("limit 30"));
        List<String> xDatas = new ArrayList<>();
        List<Double> yDatas = new ArrayList<>();
        String startTime = idxBizFanWarningRecord.getRecDate();
        String endTime = idxBizFanWarningRecord.getRecDate();
        int idxBizFanHealthIndexListSize = idxBizFanHealthIndexList.size();
        for (int i = idxBizFanHealthIndexListSize - 1; i >= 0; i--) {
            HashMap<String, String> alarmAbnormalityItem = new HashMap<>();
            FanHealthIndex idxBizFanHealthIndex = idxBizFanHealthIndexList.get(i);
            xDatas.add(idxBizFanHealthIndex.getAnalysisTime());
            yDatas.add(Double.valueOf(keepOneKeepDecimalPlace(idxBizFanHealthIndex.getHealthIndex())));
            alarmAbnormalityItem.put("sort", String.valueOf(i));
            alarmAbnormalityItem.put("time", idxBizFanHealthIndex.getAnalysisTime());
            alarmAbnormalityItem.put("abnormal", keepOneKeepDecimalPlace(idxBizFanHealthIndex.getAnomaly()));
            alarmAbnormalityItem.put("healthValue", keepOneKeepDecimalPlace(idxBizFanHealthIndex.getHealthIndex()));
            alarmAbnormalityList.add(alarmAbnormalityItem);
        }
        alarmTrendMap.put("xDatas", xDatas);
        alarmTrendMap.put("yDatas", yDatas);

        result.put("alarmTrend", alarmTrendMap);
        //  异常度 alarmAbnormality
        alarmAbnormalityList=alarmAbnormalityList.subList(alarmAbnormalityList.size() - warningCycle >= 0 ? alarmAbnormalityList.size() - warningCycle : 0, alarmAbnormalityList.size());
        alarmAbnormalityList.sort(Comparator.comparingInt(o->Integer.parseInt(o.get("sort"))));
        if(alarmAbnormalityList.size()>0){
            endTime = handlerDateStr(alarmAbnormalityList.get(0).get("time"),-8,5);
            startTime = handlerDateStr(alarmAbnormalityList.get(alarmAbnormalityList.size()-1).get("time"),-8,-5);
        }
        result.put("alarmAbnormalityList", alarmAbnormalityList);
        result.put("startTime", startTime);
        result.put("endTime", endTime);
        return result;
    }

    /**
     *  获取光伏趋势数据、异常度数据、开始时间、结束时间
     * @param idxBizPvWarningRecord
     * @return
     */
    public HashMap<String, Object> getPvAlarmTrendAndAlarmAbnormalityList(PvWarningRecord idxBizPvWarningRecord) {
        HashMap<String, Object> result = new HashMap<>();
        HashMap<String, Object> alarmTrendMap = new HashMap<>();
        HashMap<String,Object> maxValueAndWaringCycle = getWaringCycleAndMaxValueByWaring(idxBizPvWarningRecord.getWarningPeriod(),idxBizPvWarningRecord.getContent(),idxBizPvWarningRecord.getPointName());
        Integer warningCycle = Integer.valueOf(maxValueAndWaringCycle.get("warningCycle").toString());
        alarmTrendMap.put("maxValue", maxValueAndWaringCycle.get("maxValue"));
        alarmTrendMap.put("warningCycle", warningCycle);
        List<HashMap<String, String>> alarmAbnormalityList = new ArrayList<>();
        List<PvHealthIndex> idxBizPvHealthIndexList = pvHealthIndexMapper.selectList(new QueryWrapper<PvHealthIndex>()
                .eq("gateway_id", idxBizPvWarningRecord.getGatewayId())
                .eq("index_address", idxBizPvWarningRecord.getIndexAddress())
                .eq("analysis_type", idxBizPvWarningRecord.getWarningPeriod())
                .le("ts", DateUtil.offsetMinute(DateUtil.parse(idxBizPvWarningRecord.getRecDate(), DatePattern.NORM_DATETIME_PATTERN), -479))
                .orderByDesc("ts")
                .last("limit 30"));
        List<String> xDatas = new ArrayList<>();
        List<Double> yDatas = new ArrayList<>();
        String startTime = idxBizPvWarningRecord.getRecDate();
        String endTime = idxBizPvWarningRecord.getRecDate();
        int idxBizPvHealthIndexListSize = idxBizPvHealthIndexList.size();
        for (int i = idxBizPvHealthIndexList.size() - 1; i >= 0; i--) {
            HashMap<String, String> alarmAbnormalityItem = new HashMap<>();
            PvHealthIndex idxBizPvHealthIndex = idxBizPvHealthIndexList.get(i);
            xDatas.add(idxBizPvHealthIndex.getAnalysisTime());
            yDatas.add(Double.valueOf(keepOneKeepDecimalPlace(idxBizPvHealthIndex.getHealthIndex())));
            alarmAbnormalityItem.put("sort", String.valueOf(i));
            alarmAbnormalityItem.put("time", idxBizPvHealthIndex.getAnalysisTime());
            alarmAbnormalityItem.put("abnormal", keepOneKeepDecimalPlace(idxBizPvHealthIndex.getAnomaly()));
            alarmAbnormalityItem.put("healthValue", keepOneKeepDecimalPlace(idxBizPvHealthIndex.getHealthIndex()));
            if (idxBizPvHealthIndexListSize >= 3) {
                if (i == 0) {
                    endTime = handlerDateStr(idxBizPvHealthIndex.getAnalysisTime(), -8, 5);
                }
                if (i == 2) {
                    startTime = handlerDateStr(idxBizPvHealthIndex.getAnalysisTime(), -8, -5);
                }
            }
            if (idxBizPvHealthIndexListSize == 2) {
                if (i == 0) {
                    endTime = handlerDateStr(idxBizPvHealthIndex.getAnalysisTime(), -8, 5);
                }
                if (i == 1) {
                    startTime = handlerDateStr(idxBizPvHealthIndex.getAnalysisTime(), -8, -5);
                }
            }
            if (idxBizPvHealthIndexListSize == 1) {
                if (i == 0) {
                    endTime = handlerDateStr(idxBizPvHealthIndex.getAnalysisTime(), -8, 5);
                    startTime = handlerDateStr(idxBizPvHealthIndex.getAnalysisTime(), -8, -5);
                }
            }
            alarmAbnormalityList.add(alarmAbnormalityItem);
        }
        alarmTrendMap.put("xDatas", xDatas);
        alarmTrendMap.put("yDatas", yDatas);
        alarmTrendMap.put("maxValue", maxValueAndWaringCycle.get("maxValue"));
        alarmTrendMap.put("warningCycle", maxValueAndWaringCycle.get("warningCycle"));
        result.put("alarmTrend", alarmTrendMap);
        //  异常度 alarmAbnormality
        alarmAbnormalityList=alarmAbnormalityList.subList(alarmAbnormalityList.size() - warningCycle >= 0 ? alarmAbnormalityList.size() - warningCycle : 0, alarmAbnormalityList.size());
        alarmAbnormalityList.sort(Comparator.comparingInt(o->Integer.parseInt(o.get("sort"))));
        if(alarmAbnormalityList.size()>0){
            endTime = handlerDateStr(alarmAbnormalityList.get(0).get("time"),-8,5);
            startTime = handlerDateStr(alarmAbnormalityList.get(alarmAbnormalityList.size()-1).get("time"),-8,-5);
        }
        result.put("alarmAbnormalityList", alarmAbnormalityList);
        result.put("startTime", startTime);
        result.put("endTime", endTime);
        return result;
    }

    /**
     * 处理风机中心值区间值为空的情况
     * @param idxBizFanPointVarCentralValueList
     */
    public void handlerIdxBizFanPointVarCentralValue(List<IdxBizFanPointVarCentralValue> idxBizFanPointVarCentralValueList) {
        idxBizFanPointVarCentralValueList.forEach(idxBizFanPointVarCentralValue1 -> {
            if (ObjectUtils.isEmpty(idxBizFanPointVarCentralValue1.getProcess1Min())) {
                idxBizFanPointVarCentralValue1.setProcess1Min(Double.NEGATIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizFanPointVarCentralValue1.getProcess2Min())) {
                idxBizFanPointVarCentralValue1.setProcess2Min(Double.NEGATIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizFanPointVarCentralValue1.getProcess3Min())) {
                idxBizFanPointVarCentralValue1.setProcess3Min(Double.NEGATIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizFanPointVarCentralValue1.getProcess1Max())) {
                idxBizFanPointVarCentralValue1.setProcess1Max(Double.POSITIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizFanPointVarCentralValue1.getPorcess2Max())) {
                idxBizFanPointVarCentralValue1.setPorcess2Max(Double.POSITIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizFanPointVarCentralValue1.getProcess3Max())) {
                idxBizFanPointVarCentralValue1.setProcess3Max(Double.POSITIVE_INFINITY);
            }
        });
    }

    /**
     * 处理光伏中心值区间值为空的情况
     * @param idxBizPvPointVarCentralValueList
     */
    public void handlerIdxBizPvPointVarCentralValue(List<IdxBizPvPointVarCentralValue> idxBizPvPointVarCentralValueList) {
        idxBizPvPointVarCentralValueList.forEach(idxBizPvPointVarCentralValue1 -> {
            if (ObjectUtils.isEmpty(idxBizPvPointVarCentralValue1.getProcess1Min())) {
                idxBizPvPointVarCentralValue1.setProcess1Min(Double.NEGATIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizPvPointVarCentralValue1.getProcess2Min())) {
                idxBizPvPointVarCentralValue1.setProcess2Min(Double.NEGATIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizPvPointVarCentralValue1.getProcess3Min())) {
                idxBizPvPointVarCentralValue1.setProcess3Min(Double.NEGATIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizPvPointVarCentralValue1.getProcess1Max())) {
                idxBizPvPointVarCentralValue1.setProcess1Max(Double.POSITIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizPvPointVarCentralValue1.getProcess2Max())) {
                idxBizPvPointVarCentralValue1.setProcess2Max(Double.POSITIVE_INFINITY);
            }
            if (ObjectUtils.isEmpty(idxBizPvPointVarCentralValue1.getProcess3Max())) {
                idxBizPvPointVarCentralValue1.setProcess3Max(Double.POSITIVE_INFINITY);
            }
        });
    }

    /**
     *  根据工况变量值获取工况变量训练值、工况组合区间等-风机
     * @param processPoint1Value
     * @param processPoint2Value
     * @param processPoint3Value
     * @param idxBizFanPointVarCentralValueList
     * @return
     */
    public HashMap<String, String> getWorkingConditionCombinationIntervalFan(Double processPoint1Value, Double processPoint2Value, Double processPoint3Value, List<IdxBizFanPointVarCentralValue> idxBizFanPointVarCentralValueList) {
        HashMap<String, String> result = new HashMap<>();
        IdxBizFanPointVarCentralValue idxBizFanPointVarCentralValue = idxBizFanPointVarCentralValueList
                .stream()
                .filter(
                        idxBizFanPointVarCentralValue1 -> processPoint1Value >= idxBizFanPointVarCentralValue1.getProcess1Min() && processPoint1Value <= idxBizFanPointVarCentralValue1.getProcess1Max()
                                && processPoint2Value >= idxBizFanPointVarCentralValue1.getProcess2Min() && processPoint2Value <= idxBizFanPointVarCentralValue1.getPorcess2Max()
                                && processPoint3Value >= idxBizFanPointVarCentralValue1.getProcess3Min() && processPoint3Value <= idxBizFanPointVarCentralValue1.getProcess3Max()
                ).collect(Collectors.toList()).get(0);

        result.put("analysisCenterValue", String.valueOf(idxBizFanPointVarCentralValue.getAnalysisCenterValue()));
        result.put("analysisStdDev", String.valueOf(idxBizFanPointVarCentralValue.getAnalysisStdDev()));
        result.put("WorkingConditionCombinationInterval", ( "[ ["+idxBizFanPointVarCentralValue.getProcess1Min() + ":" + idxBizFanPointVarCentralValue.getProcess1Max() + "] , [" + idxBizFanPointVarCentralValue.getProcess2Min() + ":" + idxBizFanPointVarCentralValue.getPorcess2Max() + "] , [" + idxBizFanPointVarCentralValue.getProcess3Min() + ":" + idxBizFanPointVarCentralValue.getProcess3Max()+" ] ]").
                replace("Infinity", "∞"));
        return result;
    }

    /**
     * 根据工况变量值获取工况变量训练值、工况组合区间等-光伏
     * @param processPoint1Value
     * @param processPoint2Value
     * @param processPoint3Value
     * @param idxBizPvPointVarCentralValueList
     * @return
     */
    public HashMap<String, String> getWorkingConditionCombinationIntervalPv(Double processPoint1Value, Double processPoint2Value, Double processPoint3Value, List<IdxBizPvPointVarCentralValue> idxBizPvPointVarCentralValueList) {
        HashMap<String, String> result = new HashMap<>();
        IdxBizPvPointVarCentralValue idxBizPvPointVarCentralValue = idxBizPvPointVarCentralValueList
                .stream()
                .filter(
                        idxBizFanPointVarCentralValue1 -> processPoint1Value >= idxBizFanPointVarCentralValue1.getProcess1Min() && processPoint1Value <= idxBizFanPointVarCentralValue1.getProcess1Max()
                                && processPoint2Value >= idxBizFanPointVarCentralValue1.getProcess2Min() && processPoint2Value <= idxBizFanPointVarCentralValue1.getProcess2Max()
                                && processPoint3Value >= idxBizFanPointVarCentralValue1.getProcess3Min() && processPoint3Value <= idxBizFanPointVarCentralValue1.getProcess3Max()
                ).collect(Collectors.toList()).get(0);

        result.put("analysisCenterValue", String.valueOf(idxBizPvPointVarCentralValue.getAnalysisCenterValue()));
        result.put("analysisStdDev", String.valueOf(idxBizPvPointVarCentralValue.getAnalysisStdDev()));
        result.put("WorkingConditionCombinationInterval", ("[ ["+ idxBizPvPointVarCentralValue.getProcess1Min() + ":" + idxBizPvPointVarCentralValue.getProcess1Max() + "] , [" + idxBizPvPointVarCentralValue.getProcess2Min() + ":" + idxBizPvPointVarCentralValue.getProcess2Max() + "] , [" + idxBizPvPointVarCentralValue.getProcess3Min() + ":" + idxBizPvPointVarCentralValue.getProcess3Max()+" ] ]").
                replace("Infinity", "∞"));
        return result;
    }

    /**
     * 获取风机的分析变量与工况变量的笛卡尔积
     * @param idxBizFanWarningRecord
     * @return
     */
    public HashMap<String, Object> getSourceInfoMapFan(FanWarningRecord idxBizFanWarningRecord) {
        List<IdxBizFanPointVarCorrelation> idxBizFanPointVarCorrelationList = idxBizFanPointVarCorrelationMapper
                .selectList(new QueryWrapper<IdxBizFanPointVarCorrelation>().eq("EQUIPMENT_NAME", idxBizFanWarningRecord.getEquipmentName()));
        Map<String, Double> idxBizFanPointVarCorrelationListValues = new HashMap<>();
        TreeSet<String> anaylysisPonites = new TreeSet<>();
        TreeSet<String> processPointes = new TreeSet<>();
        idxBizFanPointVarCorrelationList.forEach(
                idxBizFanPointVarCorrelation -> {
                    anaylysisPonites.add(idxBizFanPointVarCorrelation.getAnalysisPointName());
                    processPointes.add(idxBizFanPointVarCorrelation.getProcessPointName());
                    idxBizFanPointVarCorrelationListValues.put(idxBizFanPointVarCorrelation
                            .getAnalysisPointName() + "_" + idxBizFanPointVarCorrelation.getProcessPointName(), idxBizFanPointVarCorrelation.getCorrelationCoefficient());
                }
        );
        HashMap<String, Object> sourceInfoMap = new HashMap<>();
        sourceInfoMap.put("xDatas", processPointes);
        sourceInfoMap.put("yDatas", anaylysisPonites);
        sourceInfoMap.put("values", idxBizFanPointVarCorrelationListValues);
        return sourceInfoMap;
    }

    /**
     * 获取光伏的分析变量与工况变量的笛卡尔积
     * @param idxBizPvWarningRecord
     * @return
     */
    public HashMap<String, Object> getSourceInfoMapPv(PvWarningRecord idxBizPvWarningRecord) {
        List<IdxBizPvPointVarCorrelation> idxBizPvPointVarCorrelationList = idxBizPvPointVarCorrelationMapper
                .selectList(new QueryWrapper<IdxBizPvPointVarCorrelation>().eq("EQUIPMENT_NAME", idxBizPvWarningRecord.getEquipmentName()));
        Map<String, Double> idxBizPvPointVarCorrelationListValues = new HashMap<>();
        TreeSet<String> anaylysisPonites = new TreeSet<>();
        TreeSet<String> processPointes = new TreeSet<>();
        idxBizPvPointVarCorrelationList.forEach(
                idxBizPvPointVarCorrelation -> {
                    anaylysisPonites.add(idxBizPvPointVarCorrelation.getAnalysisPointName());
                    processPointes.add(idxBizPvPointVarCorrelation.getProcessPointName());
                    idxBizPvPointVarCorrelationListValues.put(idxBizPvPointVarCorrelation
                            .getAnalysisPointName() + "_" + idxBizPvPointVarCorrelation.getProcessPointName(), idxBizPvPointVarCorrelation.getCorrelationCoefficient());
                }
        );
        HashMap<String, Object> sourceInfoMap = new HashMap<>();
        sourceInfoMap.put("xDatas", processPointes);
        sourceInfoMap.put("yDatas", anaylysisPonites);
        sourceInfoMap.put("values", idxBizPvPointVarCorrelationListValues);
        return sourceInfoMap;
    }

    /**
     * 获取风机的分析变量与工况变量的名称
     * @param idxBizFanPointVarCentralValue
     * @return
     */
    public HashMap<String, String> getHealthPointInfoFan(IdxBizFanPointVarCentralValue idxBizFanPointVarCentralValue) {
        HashMap<String, String> result = new HashMap<>();
        result.put("analysisPointName", idxBizFanPointVarCentralValue.getAnalysisPointName());
        result.put("processPoint1Name", idxBizFanPointVarCentralValue.getProcessPoint1Name());
        result.put("processPoint2Name", idxBizFanPointVarCentralValue.getProcessPoint2Name());
        result.put("processPoint3Name", idxBizFanPointVarCentralValue.getProcessPoint3Name());
        return result;
    }

    /**
     * 获取光伏的分析变量与工况变量的名称
     * @param idxBizPvPointVarCentralValue
     * @return
     */
    public HashMap<String, String> getHealthPointInfoPv(IdxBizPvPointVarCentralValue idxBizPvPointVarCentralValue) {
        HashMap<String, String> result = new HashMap<>();
        result.put("analysisPointName", idxBizPvPointVarCentralValue.getAnalysisPointIdName());
        result.put("processPoint1Name", idxBizPvPointVarCentralValue.getProcessPoint1IdName());
        result.put("processPoint2Name", idxBizPvPointVarCentralValue.getProcessPoint2IdName());
        result.put("processPoint3Name", idxBizPvPointVarCentralValue.getProcessPoint3IdName());
        return result;
    }

    /**
     * 获取风机的当前值与训练值
     * @param idxBizFanPointVarCentralValue
     * @param startTime
     * @param endTime
     * @param idxBizFanPointVarCentralValueList
     * @return
     */
    public HashMap<String, Object> getCurrentValueAndTrainValueInfoFan(IdxBizFanPointVarCentralValue idxBizFanPointVarCentralValue, String startTime, String endTime, List<IdxBizFanPointVarCentralValue> idxBizFanPointVarCentralValueList) {
        HashMap<String, Object> result = new HashMap<>();
        List<IdxBizFanPointProcessVariableClassification> idxBizFanPointProcessVariableClassificationList = idxBizFanPointProcessVariableClassificationMapper
                .selectList(new QueryWrapper<IdxBizFanPointProcessVariableClassification>()
                        .in("SEQUENCE_NBR", Arrays.asList(idxBizFanPointVarCentralValue.getAnalysisPointId(), idxBizFanPointVarCentralValue.getProcessPoint1Id(), idxBizFanPointVarCentralValue.getProcessPoint2Id(), idxBizFanPointVarCentralValue.getProcessPoint3Id())));
        String addresss = idxBizFanPointProcessVariableClassificationList.stream()
                .map(idxBizFanPointProcessVariableClassification -> "'" + idxBizFanPointProcessVariableClassification.getIndexAddress() + "'")
                .collect(Collectors.joining(","));
        Map<String, String> idAddressMap = idxBizFanPointProcessVariableClassificationList.stream()
                .collect(Collectors.toMap(IdxBizFanPointProcessVariableClassification::getSequenceNbr, IdxBizFanPointProcessVariableClassification::getIndexAddress));
        //查询固化数据---------------------
        List<IndicatorData> indicatorDataList = indicatorDataMapper.selectDataByGatewayIdAndAddressForAlarmInfoDetail(idxBizFanPointProcessVariableClassificationList.get(0).getGatewayId(), addresss, startTime, endTime);
        Map<String, Double> indicatorDataListMap = new HashMap<>(indicatorDataList.size());
        TreeSet<String> timesindicatorDataList = new TreeSet<>();
        indicatorDataList.forEach(indicatorData -> {
            String time = DateUtil.format(indicatorData.getCreatedTime(), DatePattern.NORM_DATETIME_MINUTE_PATTERN) + ":00";
            indicatorDataListMap.put(time + "_" + indicatorData.getAddress(), Double.valueOf(indicatorData.getValueF()));
            timesindicatorDataList.add(time);
        });
        //当前值
        List<HashMap<String, String>> currentValue = new ArrayList<>();
        //训练值
        List<HashMap<String, String>> trainValue = new ArrayList<>();
        String analyseValueAddress = idAddressMap.get(idxBizFanPointVarCentralValue.getAnalysisPointId());
        String process1Address = idAddressMap.get(idxBizFanPointVarCentralValue.getProcessPoint1Id());
        String process2Address = idAddressMap.get(idxBizFanPointVarCentralValue.getProcessPoint2Id());
        String process3Address = idAddressMap.get(idxBizFanPointVarCentralValue.getProcessPoint3Id());
        List<String> timesindicatorDataListSorted = timesindicatorDataList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        timesindicatorDataListSorted.forEach(
                s -> {
                    HashMap<String, String> currentValueMap = new HashMap<>();
                    currentValueMap.put("time", s);
                    Double analyseValue = indicatorDataListMap.get(s + "_" + analyseValueAddress);
                    Double processValue1 = indicatorDataListMap.get(s + "_" + process1Address);
                    Double processValue2 = indicatorDataListMap.get(s + "_" + process2Address);
                    Double processValue3 = indicatorDataListMap.get(s + "_" + process3Address);
                    currentValueMap.put("analyseValue", keepOneKeepDecimalPlace(analyseValue));
                    currentValueMap.put("processValue1", keepOneKeepDecimalPlace(processValue1));
                    currentValueMap.put("processValue2", keepOneKeepDecimalPlace(processValue2));
                    currentValueMap.put("processValue3", keepOneKeepDecimalPlace(processValue3));
                    HashMap<String, String> trainValueMap = getWorkingConditionCombinationIntervalFan(processValue1, processValue2, processValue3, idxBizFanPointVarCentralValueList);
                    trainValueMap.put("time", s);
                    currentValue.add(currentValueMap);
                    trainValue.add(trainValueMap);
                }
        );
        result.put("currentValue", currentValue);
        result.put("trainValue", trainValue);
        return result;
    }

    /**
     * 获取光伏的当前值与训练值
     * @param idxBizPvPointVarCentralValue
     * @param startTime
     * @param endTime
     * @param idxBizPvPointVarCentralValueList
     * @return
     */
    public HashMap<String, Object> getCurrentValueAndTrainValueInfoPv(IdxBizPvPointVarCentralValue idxBizPvPointVarCentralValue, String startTime, String endTime, List<IdxBizPvPointVarCentralValue> idxBizPvPointVarCentralValueList) {
        HashMap<String, Object> result = new HashMap<>();
        List<IdxBizPvPointProcessVariableClassification> idxBizPvPointProcessVariableClassificationList = idxBizPvPointProcessVariableClassificationMapper
                .selectList(new QueryWrapper<IdxBizPvPointProcessVariableClassification>()
                        .in("SEQUENCE_NBR", Arrays.asList(idxBizPvPointVarCentralValue.getAnalysisPointId(), idxBizPvPointVarCentralValue.getProcessPoint1Id(), idxBizPvPointVarCentralValue.getProcessPoint2Id(), idxBizPvPointVarCentralValue.getProcessPoint3Id())));
        String addresss = idxBizPvPointProcessVariableClassificationList.stream()
                .map(idxBizFanPointProcessVariableClassification -> "'" + idxBizFanPointProcessVariableClassification.getIndexAddress() + "'")
                .collect(Collectors.joining(","));
        Map<String, String> idAddressMap = idxBizPvPointProcessVariableClassificationList.stream()
                .collect(Collectors.toMap(IdxBizPvPointProcessVariableClassification::getSequenceNbr, IdxBizPvPointProcessVariableClassification::getIndexAddress));
        //查询固化数据---------------------
        List<IndicatorData> indicatorDataList = indicatorDataMapper.selectDataByGatewayIdAndAddressForAlarmInfoDetail(idxBizPvPointProcessVariableClassificationList.get(0).getGatewayId(), addresss, startTime, endTime);
        Map<String, Double> indicatorDataListMap = new HashMap<>(indicatorDataList.size());
        TreeSet<String> timesindicatorDataList = new TreeSet<>();
        indicatorDataList.forEach(indicatorData -> {
            String time = DateUtil.format(indicatorData.getCreatedTime(), DatePattern.NORM_DATETIME_MINUTE_PATTERN) + ":00";
            indicatorDataListMap.put(time + "_" + indicatorData.getAddress(), Double.valueOf(indicatorData.getValueF()));
            timesindicatorDataList.add(time);
        });
        //当前值
        List<HashMap<String, String>> currentValue = new ArrayList<>();
        //训练值
        List<HashMap<String, String>> trainValue = new ArrayList<>();
        String analyseValueAddress = idAddressMap.get(idxBizPvPointVarCentralValue.getAnalysisPointId());
        String process1Address = idAddressMap.get(idxBizPvPointVarCentralValue.getProcessPoint1Id());
        String process2Address = idAddressMap.get(idxBizPvPointVarCentralValue.getProcessPoint2Id());
        String process3Address = idAddressMap.get(idxBizPvPointVarCentralValue.getProcessPoint3Id());
        List<String> timesindicatorDataListSorted = timesindicatorDataList.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        timesindicatorDataListSorted.forEach(
                s -> {
                    HashMap<String, String> currentValueMap = new HashMap<>();
                    currentValueMap.put("time", s);
                    Double analyseValue = indicatorDataListMap.get(s + "_" + analyseValueAddress);
                    Double processValue1 = indicatorDataListMap.get(s + "_" + process1Address);
                    Double processValue2 = indicatorDataListMap.get(s + "_" + process2Address);
                    Double processValue3 = indicatorDataListMap.get(s + "_" + process3Address);
                    currentValueMap.put("analyseValue", keepOneKeepDecimalPlace(analyseValue));
                    currentValueMap.put("processValue1", keepOneKeepDecimalPlace(processValue1));
                    currentValueMap.put("processValue2", keepOneKeepDecimalPlace(processValue2));
                    currentValueMap.put("processValue3", keepOneKeepDecimalPlace(processValue3));
                    HashMap<String, String> trainValueMap = getWorkingConditionCombinationIntervalPv(processValue1, processValue2, processValue3, idxBizPvPointVarCentralValueList);
                    trainValueMap.put("time", s);
                    currentValue.add(currentValueMap);
                    trainValue.add(trainValueMap);
                }
        );
        result.put("currentValue", currentValue);
        result.put("trainValue", trainValue);
        return result;
    }

    /**
     * 将字符时间进行小时、分钟偏移后返回格式化后的数据-主要用于查询固化值
     * @param dateStr
     * @param offsetHour
     * @param offsetMinutes
     * @return
     */
    public String handlerDateStr(String dateStr, Integer offsetHour, Integer offsetMinutes) {
        Date date = DateUtil.parse(dateStr);
        date = DateUtil.offsetHour(date, offsetHour);
        date = DateUtil.offsetMinute(date, offsetMinutes);
        return DateUtil.format(date, DatePattern.NORM_DATETIME_PATTERN);
    }

    /**
     * 根据预预警类型获取预警周期与预警值
     * @return
     */
    public HashMap<String,Object> getWaringCycleAndMaxValueByWaring(String warningPeriod,String warningContenct,String pointName){
        HashMap<String,Object> result = new HashMap<>();
        warningContenct=warningContenct.replace(pointName+"连续","");
        String spiltStr =CommonConstans.waringPeriodTowaringCycle.get(warningPeriod);
        String [] strings= warningContenct.split(spiltStr);
        Double maxValue=0.0;
        Integer warningCycle=1;
        if(strings.length == 2){
            if (spiltStr.equals("分钟")){
                warningCycle = Integer.valueOf(strings[0])/10;
            }else {
                warningCycle=Integer.valueOf(strings[0]);
            }
            if(strings[1].contains("<")){
                maxValue = Double.valueOf(strings[1].split("<")[1]);
            }
        }
        result.put("maxValue",maxValue);
        result.put("warningCycle",warningCycle);
        return result;
    }

    /**
     * 保留一位小数
     * @param input
     * @return
     */
    public String keepOneKeepDecimalPlace(Double input){
        String result = "0.0";
        if(!ObjectUtils.isEmpty(input)){
            return String.format("%.1f",input) ;
        }
        return  result;
    }
}
