package com.yeejoin.amos.boot.module.jcs.biz.controller.event;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.OperateLogModel;

import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.event.RestEvent;
import org.typroject.tyboot.component.event.RestEventHandler;
import org.typroject.tyboot.core.foundation.context.RequestContext;

/**
 * 
 * <pre>
 * controller层操作日志事件监听
 * </pre>
 *
 * @author gwb
 * @version $Id: OpreateLogEventHandler.java, v 0.1 2021年8月19日 下午6:38:36 gwb Exp $
 */
@Component("opreateLogEventHandler")
public class OpreateLogEventHandler extends RestEventHandler {

    static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    protected void handleEvent(RestEvent restEvent) throws Exception {

        OperateLogModel operateLogModel =new OperateLogModel();
        operateLogModel.setMethodLabel(restEvent.getMethodLabel());
        operateLogModel.setMethodName(restEvent.getMethodName());
        operateLogModel.setParams(objectMapper.writeValueAsString(restEvent.getParams()));
        operateLogModel.setResult(objectMapper.writeValueAsString(restEvent.getSource()));
        operateLogModel.setUserId(restEvent.getRequestContextModel().getExcutedUserId());
        operateLogModel.setRemoteIp(restEvent.getRequestContextModel().getRequestIP());
        operateLogModel.setToken(restEvent.getRequestContextModel().getToken());
        operateLogModel.setTraceId(restEvent.getRequestContextModel().getTraceId());
        operateLogModel.setAgencyCode(restEvent.getRequestContextModel().getAgencyCode());
        operateLogModel.setAppCode(restEvent.getRequestContextModel().getAppKey());
        
        
        RequestContext.setAppKey(restEvent.getRequestContextModel().getAppKey());
        RequestContext.setProduct(restEvent.getRequestContextModel().getProduct());
        RequestContext.setToken(restEvent.getRequestContextModel().getToken());
        
        Systemctl.operateLogClient.create(operateLogModel);
    }
}
