package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.enums.FileFolderPathEnum;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

@RestController
@RequestMapping(value = "/filestorage")
@Api(tags = "filestorage-上传附件数据对接")
public class FilesController {
    private static final Logger logger = LogManager.getLogger(FilesController.class);

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "气瓶充装审核数据")
    @PostMapping(value = "/")
    public ResponseModel<String> uploadCylinderFiles(
            @RequestBody MultipartFile file) throws Exception {
        logger.info(file);
        JSONObject jsonObj = uploadFile(file, FileFolderPathEnum.CYLINDER.getPath());
        return ResponseHelper.buildResponse(jsonObj.toString());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "检验报告数据")
    @PostMapping(value = "/csei")
    public ResponseModel<String> uploadCseiFiles(
            @RequestBody MultipartFile file) throws Exception {
        logger.info(file);
        JSONObject jsonObj = uploadFile(file, FileFolderPathEnum.JY.getPath());
        return ResponseHelper.buildResponse(jsonObj.toString());
    }

    private JSONObject uploadFile(MultipartFile file, String tag) {
        if (ValidationUtil.isEmpty(file)) {
            throw new BadRequest("参数校验失败.");
        }
        Date today = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        String path = format.format(today);
        FeignClientResult<Map<String, String>> date = Systemctl.fileStorageClient.updateCommonFileFree(file, "tzs/" + tag + "/" + path);
        JSONObject jsonObj = new JSONObject();
        if (date != null) {
            Map<String, String> map = date.getResult();
            Iterator<String> it = map.keySet().iterator();
            while (it.hasNext()) {
                String urlString = it.next();
                jsonObj.put("fileUrl", urlString);
                jsonObj.put("fileName", map.get(urlString));
            }
        }
        return jsonObj;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "上传附件")
    @PostMapping("/supma")
    public ResponseModel<JSONObject> upload(@RequestBody MultipartFile file) {
        JSONObject jsonObject = uploadFile(file, FileFolderPathEnum.JG.getPath());
        return ResponseHelper.buildResponse(jsonObject);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "通用上传附件")
    @PostMapping("/{module}/upload")
    public ResponseModel<JSONObject> upload2(@RequestBody MultipartFile file, @PathVariable String module) {
        JSONObject jsonObject = uploadFile(file, FileFolderPathEnum.valueOf(module.toUpperCase()).getPath());
        return ResponseHelper.buildResponse(jsonObject);
    }

}
