package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 使用信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("mid_equip_use_info")
public class UseInfo extends AbstractEquipBaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     *  	 * 监管码
     *      */

    @TableField(value ="\"SUPERVISORY_CODE\"")
    private String supervisoryCode;
      /**
     *  	 * $column.comments
     *      */

    @TableField(value ="\"INSTANCE_ID\"")
    private String instanceId;
    /**
     *  	 * $column.comments
     *      */

    @TableField(value ="\"STATUS\"")
    private String status;
    /**
     *  	 * 使用单位统一信用代码
     *      */

    @TableField(value ="\"USE_UNIT_CREDIT_CODE\"")
    private String useUnitCreditCode;
    /**
     *  	 * 使用单位名称
     *      */

    @TableField(value ="\"USE_UNIT_NAME\"")
    private String useUnitName;
    /**
     *  	 * 产权单位统一信用代码
     *      */

    @TableField(value ="\"ESTATE_UNIT_CREDIT_CODE\"")
    private String estateUnitCreditCode;
    /**
     *  	 * 产权单位名称
     *      */

    @TableField(value ="\"ESTATE_UNIT_NAME\"")
    private String estateUnitName;
    /**
     *  	 * 使用状态变更日期
     *      */

    @TableField(value ="\"USE_STATE_CHANGE_DATE\"")
    private String useStateChangeDate;
    /**
     *  	 * 变更事项
     *      */

    @TableField(value ="\"CHANGES\"")
    private String changes;
    /**
     *  	 * 使用内部编号
     *      */

    @TableField(value ="\"USE_INNER_CODE\"")
    private String useInnerCode;
    /**
     *  	 * 投入使用日期
     *      */

    @TableField(value ="\"USE_DATE\"")
    private String useDate;
    /**
     *  	 * 经办人
     *      */

    @TableField(value ="\"AGENT\"")
    private String agent;
    /**
     *  	 * 设备使用地点-省
     *      */

    @TableField(value ="\"PROVINCE\"")
    private String province;
    /**
     *  	 * 设备使用地点-市
     *      */

    @TableField(value ="\"CITY\"")
    private String city;
    /**
     *  	 * 设备使用地点-区（县）
     *      */

    @TableField(value ="\"COUNTY\"")
    private String county;
    /**
     *  	 * 设备使用地点-街道（镇）
     *      */

    @TableField(value ="\"FACTORY_USE_SITE_STREET\"")
    private String factoryUseSiteStreet;
    /**
     *  	 * 设备详细使用地址
     *      */

    @TableField(value ="\"ADDRESS\"")
    private String address;
    /**
     *  	 * 设备地理坐标经纬度
     *      */

    @TableField(value ="\"LONGITUDE_LATITUDE\"")
    private String longitudeLatitude;
    /**
     *  	 * 设备使用场所
     *      */

    @TableField(value ="\"USE_PLACE\"")
    private String usePlace;
    /**
     *  	 * 设备主管部门
     *      */

    @TableField(value ="\"EQU_MANAGE_DT\"")
    private String equManageDt;
    /**
     *  	 * 安全管理部门名称
     *      */

    @TableField(value ="\"SAFETY_MANAGE_DT\"")
    private String safetyManageDt;
    /**
     *  	 * 安全管理员
     *      */

    @TableField(value ="\"SAFETY_MANAGER\"")
    private String safetyManager;
    /**
     *  	 * 安全管理员移动电话
     *      */

    @TableField(value ="\"PHONE\"")
    private String phone;
    /**
     *  	 * 设备状态
     *      */

    @TableField(value ="\"EQU_STATE\"")
    private String equState;
    /**
     *  	 * $column.comments
     *      */

    @TableField(value ="\"PROVINCE_NAME\"")
    private String provinceName;
    /**
     *  	 * $column.comments
     *      */

    @TableField(value ="\"CITY_NAME\"")
    private String cityName;
    /**
     *  	 * $column.comments
     *      */

    @TableField(value ="\"COUNTY_NAME\"")
    private String countyName;

    /**
     * 是否西咸（0不是，1是）
     */
    private String isXiXian;

    /**
     * 是否在es（0不是，1是）
     */
    private String isEs;

    /**
     * 创建时间
     * */
    private Date createDate;

    /**
     * 认领时间
     * */
    private Date claimDate;

    /**
     * 数据来源（新增：0、导入：1、复制：复制数据的id ）
     * */
    private Date dataSource;
}
