package com.yeejoin.amos.boot.module.jyjc.biz.job;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcBaseMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.NeedTipEquipInfo;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.UseInfoModel;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquimentEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzsUserInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.MessageModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Service
@Slf4j
public class InspectionExpireRemindJob {


    private static Map<String, String> EQU_LIST_MAP = new HashMap<>();

    static {
        EQU_LIST_MAP.put("9000", "客运索道");
        EQU_LIST_MAP.put("7000", "压力管道元件");
        EQU_LIST_MAP.put("6000", "大型游乐设施");
        EQU_LIST_MAP.put("2000", "压力容器");
        EQU_LIST_MAP.put("F000", "安全附件");
        EQU_LIST_MAP.put("5000", "场（厂）内专用机动车辆");
        EQU_LIST_MAP.put("1000", "锅炉");
        EQU_LIST_MAP.put("8000", "压力管道");
        EQU_LIST_MAP.put("3000", "电梯");
        EQU_LIST_MAP.put("4000", "起重机械");
    }


    private UseInfoMapper useInfoMapper;


    private TzsUserInfoMapper tzsUserInfoMapper;

    private AmosRequestContext amosRequestContext;

    private JyjcBaseMapper jyjcBaseMapper;

    public InspectionExpireRemindJob(UseInfoMapper useInfoMapper,
                                     TzsUserInfoMapper tzsUserInfoMapper,
                                     AmosRequestContext amosRequestContext,
                                     JyjcBaseMapper jyjcBaseMapper) {
        this.useInfoMapper = useInfoMapper;
        this.tzsUserInfoMapper = tzsUserInfoMapper;
        this.amosRequestContext = amosRequestContext;
        this.jyjcBaseMapper = jyjcBaseMapper;
    }


    public void sendReminderMessage() {
        // 1.查询临期和超期的设备
        List<NeedTipEquipInfo> needTipEquipList = getNeedTipEquipList();
        // 2.填充接收人【查询设备的使用单位企业所有人（有amos账号）、设备的管辖机构（所、区县、地市、省）】
        this.fillReceiveUsers(needTipEquipList);
        // 3.按照设备维度创建提醒消息，批量调用平台
        this.createTask(needTipEquipList);
    }


    private List<NeedTipEquipInfo> getNeedTipEquipList() {
        // 查询需要进行消息提醒的设备集合
        List<String> statusList = new ArrayList<>();
        statusList.add(EquimentEnum.ZAIYONG.getCode().toString());
        List<UseInfoModel> needTipEquipList = useInfoMapper.selecEquipInfotList(statusList, 30);
        // 对象转换及管辖机构集合填充
        return this.buildTipEquipInfoList(needTipEquipList);
    }


    private void fillReceiveUsers(List<NeedTipEquipInfo> needTipEquipList) {
        // 使用单位
        List<String> allUnitCodes = needTipEquipList.stream().map(NeedTipEquipInfo::getUseUnitCreditCode).distinct().collect(Collectors.toList());
        // 查询使用单位下的人-数据库-批量查询
        List<TzsUserInfo> useUnitUserList = this.getUseUnitUserList(allUnitCodes);
        // 查询管辖单位下的人-数据库-批量查询
        List<TzsUserInfoDto> superviseUnitUserList = this.getSuperviseUnitUserList(needTipEquipList);
        // 以设备为维度，把 需要发送消息的人进行合并
        needTipEquipList.forEach(e -> {
            e.setReceiveUsers(useUnitUserList.stream().filter(u -> e.getUseUnitCreditCode().equals(u.getUnitCode())).map(TzsUserInfo::getAmosUserId).collect(Collectors.toSet()));
            e.getReceiveUsers().addAll(superviseUnitUserList.stream().filter(u -> e.getParentOrgBranchCode().contains(u.getOrgCode())).map(TzsUserInfoDto::getAmosUserId).collect(Collectors.toSet()));
        });
        // 人员去重，字符串可能为:元素1：8551496,8551496,8551496，元素2：8551496,8551497，需要转为8551496、8551497
        needTipEquipList.forEach(e -> {
            Set<String> userIds = new HashSet<>();
            e.getReceiveUsers().forEach(item -> {
                userIds.addAll(Arrays.asList(item.split(",")));
            });
            e.setReceiveUsers(userIds);
        });
    }

    private List<TzsUserInfoDto> getSuperviseUnitUserList(List<NeedTipEquipInfo> needTipEquipList) {
        Set<String> allParentOrgCodes = new HashSet<>();
        needTipEquipList.forEach(e -> allParentOrgCodes.addAll(e.getParentOrgBranchCode()));
        return jyjcBaseMapper.selectParentOrgUsers(allParentOrgCodes);
    }

    private List<TzsUserInfo> getUseUnitUserList(List<String> allUnitCodes) {
        LambdaQueryWrapper<TzsUserInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(TzsUserInfo::getAmosUserId, TzsUserInfo::getUnitCode);
        queryWrapper.in(TzsUserInfo::getUnitCode, allUnitCodes);
        queryWrapper.eq(BaseEntity::getIsDelete, false);
        queryWrapper.isNotNull(TzsUserInfo::getAmosUserId);
        return tzsUserInfoMapper.selectList(queryWrapper);
    }

    private List<NeedTipEquipInfo> buildTipEquipInfoList(List<UseInfoModel> needTipEquipList) {
        return needTipEquipList.stream().map(c -> {
            NeedTipEquipInfo tipEquipInfo = new NeedTipEquipInfo();
            BeanUtil.copyProperties(c, tipEquipInfo);
            Set<String> parentUnitCodes = new HashSet<>();
            int index = tipEquipInfo.getOrgBranchCode().lastIndexOf("*");
            if (index >= 0) {
                parentUnitCodes.add(tipEquipInfo.getOrgBranchCode().substring(0, index));
                setPatentCode(parentUnitCodes, tipEquipInfo.getOrgBranchCode().substring(0, index));
            }
            tipEquipInfo.setEquListName(EQU_LIST_MAP.get(tipEquipInfo.getEquList()));
            tipEquipInfo.setParentOrgBranchCode(parentUnitCodes);
            return tipEquipInfo;
        }).collect(Collectors.toList());
    }

    private void setPatentCode(Set<String> parentUnitCodes, String current) {
        int index = current.lastIndexOf("*");
        if (index >= 0) {
            parentUnitCodes.add(current.substring(0, index));
            setPatentCode(parentUnitCodes, current.substring(0, index));
        }
    }


    private void createTask(List<NeedTipEquipInfo> needTipEquipList) {
        List<MessageModel> messageModels = new LinkedList<>();
        needTipEquipList.parallelStream().forEach(e -> messageModels.add(this.buildTaskModel(e)));
        messageModels.forEach(m -> {
            RequestContext.setToken(amosRequestContext.getToken());
            RequestContext.setProduct(amosRequestContext.getProduct());
            RequestContext.setAppKey(amosRequestContext.getAppKey());
            log.info("开始调用平台创建消息：{}", JSONObject.toJSONString(m));
            Systemctl.messageClient.create(m);
        });
    }

    private MessageModel buildTaskModel(NeedTipEquipInfo e) {
        MessageModel messageModel = new MessageModel();
        // 消息类型
        messageModel.setTitle(e.getTitle());
        // 消息内容
        messageModel.setBody(e.getContent());
        // 关联id
        messageModel.setRelationId(e.getRecord());
        messageModel.setMsgType(e.getStatus());
        messageModel.setMsgTypeLabel(e.getTitle());
        messageModel.setRecivers(new ArrayList<>(e.getReceiveUsers()));
        messageModel.setAgencyCode("tzs");
        messageModel.setSendTime(new Date());
        messageModel.setTerminal("WEB");
        return messageModel;
    }


}
