package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.EquipmentAssociatedServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentAssociatedDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 配套设备/设施/部件
 *
 * @author system_generator
 * @date 2021-11-26
 */
@RestController
@Api(tags = "配套设备/设施/部件Api")
@RequestMapping(value = "/equipment-associated")
public class EquipmentAssociatedController extends BaseController {

    @Autowired
    EquipmentAssociatedServiceImpl equipmentAssociatedServiceImpl;

    /**
     * 新增配套设备/设施/部件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增配套设备/设施/部件", notes = "新增配套设备/设施/部件")
	public ResponseModel<EquipmentAssociatedDto> save(@RequestBody EquipmentAssociatedDto model) {
	    model = equipmentAssociatedServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新配套设备/设施/部件", notes = "根据sequenceNbr更新配套设备/设施/部件")
	public ResponseModel<EquipmentAssociatedDto> updateBySequenceNbrEquipmentAssociated(@RequestBody EquipmentAssociatedDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(equipmentAssociatedServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除配套设备/设施/部件", notes = "根据sequenceNbr删除配套设备/设施/部件")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(equipmentAssociatedServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个配套设备/设施/部件",  notes = "根据sequenceNbr查询单个配套设备/设施/部件")
	public ResponseModel<EquipmentAssociatedDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(equipmentAssociatedServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "配套设备/设施/部件分页查询",  notes = "配套设备/设施/部件分页查询")
	public ResponseModel<Page<EquipmentAssociatedDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<EquipmentAssociatedDto> page = new Page<EquipmentAssociatedDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(equipmentAssociatedServiceImpl.queryForEquipmentAssociatedPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "配套设备/设施/部件列表全部数据查询",   notes = "配套设备/设施/部件列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<EquipmentAssociatedDto>> selectForList() {
	    return ResponseHelper.buildResponse(equipmentAssociatedServiceImpl.queryForEquipmentAssociatedList());
	}
}
