package com.yeejoin.amos.speech;

import okhttp3.*;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * okHttp客户端
 */
public class AppOkHttpClient {

    static OkHttpClient client = new OkHttpClient
            .Builder()
            .connectTimeout(20, TimeUnit.SECONDS)
            .readTimeout(120, TimeUnit.SECONDS)
            .writeTimeout(120, TimeUnit.SECONDS)
            .build();

    /**
     * okHttp post提交文件请求
     *
     * @param url        请求地址
     * @param headers    请求头
     * @param speechFile 待识别文件
     * @param callback   识别回调函数
     */
    public static void sendPostFile(String url, HashMap<String, String> headers, File speechFile, Callback callback) {
        RequestBody body = RequestBody.create(MediaType.parse("application/octet-stream"), speechFile);
        Headers.Builder hb = new Headers.Builder();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                hb.add(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder()
                .url(url)
                .headers(hb.build())
                .post(body)
                .build();
        client.newCall(request).enqueue(callback);
    }
}