package com.yeejoin.amos.boot.module.jg.api.enums;

/**
 * 办理状态枚举
 */
public enum PrintingTypeEnum {

    /**
     * 登记证（普打）
     */
    REGULAR(2, "登记证（普打）"),
    OVERPLAY(3, "登记证（套打）"),
    /**
     * 登记证（电子版）
     */
    ELECTRONIC(1, "登记证（电子版）");

    private final Integer code;

    private final String name;

    PrintingTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
