package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@TableName("f_system_equipment_relation")
@ApiModel(value = "f_system_equipment_relation", description = "消防系统部件关系")
public class SystemEquipmentRelationEntity extends BaseEntity {

    @ApiModelProperty(value = "系统ID")
    private Long systemId;

    @ApiModelProperty(value = "分组编码")
    private Long equipmentId;

    @ApiModelProperty(value = "类型（0：系统部件、1：安措）")
    private Integer type;

    @ApiModelProperty(value = "部件排序")
    private Integer sort;
}
