package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 管控措施结果表
 *
 * @author duanwei
 * @date 2021-02-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_risk_work_measure_result")
@ApiModel(value="TaskRiskWorkMeasureResult对象", description="管控措施结果表")
public class TaskRiskWorkMeasureResult extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "风险计划id")
    private Long taskRiskControlId;

    @ApiModelProperty(value = "作业活动id")
    private Long riskWorkId;

    @ApiModelProperty(value = "管控措施名称")
    private String name;

    @ApiModelProperty(value = "编号（暂未使用）")
    private String code;

    @ApiModelProperty(value = "结果(0未选 1不合格 2合格)")
    private Long isOk;

    @ApiModelProperty(value = "原因")
    private String reason;
}
