package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.Plan;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("planDao")
public interface IPlanDao extends BaseDao<Plan, Long> {
    @Modifying
    @Transactional
    @Query(value = "delete from p_plan where id in (?1)", nativeQuery = true)
    void delPlanBatch(List<Long> ids);

    @Modifying
    @Transactional
    @Query(value = "select * from p_plan WHERE next_gen_date = ?1 and (status = ?2 or status = ?3)", nativeQuery = true)
    List<Plan> queryScheduledPlan(String strDate, String status,  String status1);

    @Modifying
    @Transactional
    @Query(value = "select * from p_plan WHERE status NOT IN (0,7,8)", nativeQuery = true)
    List<Plan> queryOutTimePlan();

    @Modifying
    @Transactional
    @Query(value = "select * from p_plan WHERE route_id = ?1 and status = ?2", nativeQuery = true)
    List<Plan> queryPlanByRouteId(long routeId, String status);

    @Modifying
    @Transactional
    @Query(value = "UPDATE p_plan SET is_delete = 1,`status` = 1 WHERE id IN (?1)", nativeQuery = true)
    void updatePlanDel(List<Long> ids);

    @Modifying
    @Transactional
    @Query(value = "UPDATE p_plan SET `status` = (?1) WHERE id = (?2)", nativeQuery = true)
    void updatePlanStatus(Integer status, Long planId);

    Plan findByOriginalId(String originalId);

    @Query(value = "select * from p_plan where original_id in (?1) and is_delete = 0", nativeQuery = true)
    List<Plan> findByOriginalIds(List<String> originalIds);

    @Query(value = "select count(*) from p_plan where is_delete = 0 and id in (?1) and status != (?2)", nativeQuery =
            true)
    int countNotDeletable(List<Long> ids, int status);
}