package com.yeejoin.amos;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;

/**
 * <pre>
 * 服务启动类
 * </pre>
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableDiscoveryClient
@EnableFeignClients(basePackages = {"com.yeejoin"})
@EnableAsync
@MapperScan({"org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
        "org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
        "com.yeejoin.amos.boot.module.*.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper",
		"com.yeejoin.amos.avic.face.orm.dao*"})
@ComponentScan(basePackages = {"org.typroject", "com.yeejoin"})
public class AmoAVICApplication {
    private static final Logger logger = LoggerFactory.getLogger(AmoAVICApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        ConfigurableApplicationContext context = SpringApplication.run(AmoAVICApplication.class, args);
        Environment env = context.getEnvironment();
        String appName = env.getProperty("spring.application.name");
        logger.info(
                "\n----------------------------------------------------------\n\t"
                        + "Application {} is running!\n"
                        + "----------------------------------------------------------\n"
                , appName
        );
    }

}
