package com.yeejoin.amos.patrol.business.service.action;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.patrol.business.bo.CheckInputSyncBo;
import com.yeejoin.amos.patrol.business.dao.mapper.CheckInputMapper;
import com.yeejoin.amos.patrol.business.dao.repository.ICheckInputDao;
import com.yeejoin.amos.patrol.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.patrol.business.entity.mybatis.EquipmentInputItemRo;
import com.yeejoin.amos.patrol.business.service.intfc.IPatrolDataSyncService;
import com.yeejoin.amos.patrol.common.enums.CheckStatusEnum;
import com.yeejoin.amos.patrol.common.enums.YesOrNoEnum;
import com.yeejoin.amos.patrol.dao.entity.CheckInput;
import com.yeejoin.amos.patrol.dao.entity.InputItem;
import com.yeejoin.amos.patrol.mqtt.WebMqttComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author keyong
 * @title: HandlerMqttMessageImpl
 * <pre>
 * @description: 获取装备规则
 * </pre>
 * @date 2020/11/10 18:03
 */
@Component("AcceptEquipmentRules")
public class AcceptEquipmentRules {
    private final Logger log = LoggerFactory.getLogger(AcceptEquipmentRules.class);

    @Autowired
    private IInputItemDao iInputItemDao;
    @Autowired
    private ICheckInputDao checkInputDao;
    @Value("${input.statute.prefix}")
    private String statutePre;

    @Autowired
    private IPatrolDataSyncService patrolDataSyncService;

    @Autowired
    private CheckInputMapper checkInputMapper;

    public void getContent(
            String itemNo,
            String inputClassify,
            String inputJson,
            String pictureJson,
            String basisJson,
            String checkMethod,
            String level,
            String riskDesc,
            EquipmentInputItemRo ro,
            Integer orderNo,
            String title,
            String itemType,
            String isMust,
            String isScore,
            String defaultValue,
            String isMultiline
    ){
        InputItem item = new InputItem();
        item.setItemNo(statutePre+itemNo);
        item.setName(title);
        item.setDataJson(inputJson);

        item.setBasisJson(basisJson);
//        [{"isMust":"是","name":"选择拍照","orderNo":0}]
        JSONArray pictureArray = new JSONArray();
        if(YesOrNoEnum.YES.getName().equals(pictureJson)){
            JSONObject pictureObject = new JSONObject();
            pictureObject.put("isMust",YesOrNoEnum.YES.getName());
            pictureObject.put("name","拍照");
            pictureObject.put("orderNo","0");
            pictureArray.add(pictureObject);
            item.setPictureJson(pictureArray.toJSONString());
        }else{
            item.setPictureJson(pictureArray.toJSONString());
        }
        item.setCheckMethod(checkMethod);
        if("单行文本".equals(inputClassify)){
            item.setItemType("文本");
            item.setIsMultiline(YesOrNoEnum.NO.getName());
        }else if("多行文本".equals(inputClassify)){
            item.setItemType("文本");
            item.setIsMultiline(YesOrNoEnum.YES.getName());
        } else{
            item.setItemType(inputClassify);
        }
        item.setInputClassify(itemType);
        item.setLevel(level);
        item.setRiskDesc(riskDesc);
        item.setInputType(Integer.parseInt(YesOrNoEnum.YES.getCode()));
        item.setEquipmentName(ro.getEquipmentName());
        item.setOrderNo(orderNo);
        item.setOrgCode(ro.getOrgCode());
        item.setTitle(title);
        item.setIsMust(isMust);
        item.setIsScore(isScore);
        item.setDefaultValue(defaultValue);
        List<InputItem> inputItems =  iInputItemDao.findByItemNoAndEquipmentName(item.getItemNo(),ro.getEquipmentName());
        if(inputItems.size()>0){
            iInputItemDao.deleteAll(inputItems);
            iInputItemDao.save(item);
        }else{
            iInputItemDao.save(item);
        }
//        String topic = "/check/equipment/rules";
//        item.setPictureJson(pictureJson);
//        webMqttComponent.publish(topic,JSONObject.toJSON(item).toString());
    }


    public void  checkResult (String result,String score,EquipmentInputItemRo ro){
        Optional<CheckInput> checkInputOptional = checkInputDao.findById(Long.parseLong(ro.getCheckInputId()));
        CheckInput checkInput = checkInputOptional.get();
        checkInput.setScore(Integer.parseInt(score));
        if(CheckStatusEnum.QUALIFIED.getName().equals(result)){
            checkInput.setIsOk(CheckStatusEnum.QUALIFIED.getCode());
        }else{
            checkInput.setIsOk(CheckStatusEnum.UNQUALIFIED.getCode());
        }
        checkInputDao.save(checkInput);
        //  巡检站端与中心级数据同步
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                // 事物提交后业务逻辑
                Map<String, Object> map = new HashMap<>();
                map.put("id", checkInput.getId());
                List<CheckInputSyncBo> checkInputSyncBoList = checkInputMapper.getCheckInputSyncBoList(map);
                patrolDataSyncService.checkInputBoDataSync(checkInputSyncBoList);
                patrolDataSyncService.checkInputDataSync(checkInput);
            }
        });
        log.info(checkInput.getPointClassifyName()+"规则校验返回结果修改成功");
    }
}
