package com.yeejoin.amos.boot.module.jg.api.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;


/**
 * @author shg
 */
@Data
@ApiModel("监管业务办理统计基础对象")
public class JgBizEquipStateCountVo implements Serializable {

    public JgBizEquipStateCountVo() {
        this.id = UUID.randomUUID().toString();
    }

    private String id;

    @ApiModelProperty("地市管辖机构")
    private String cityManagementUnitName;

    @ApiModelProperty("区县管辖机构")
    private String countyManagementUnitName;

    @ApiModelProperty("直接管辖机构")
    private String managementUnitName;

    @ApiModelProperty("设备种类")
    private String equListName;

    @ApiModelProperty("设备类别")
    private String equCategoryName;

    @ApiModelProperty("设备品种")
    private String equDefineName;

    @ApiModelProperty("总数设备数量")
    private Long totalNumber;

    @ApiModelProperty("在用设备数量")
    private Long inUseNumber;

    @ApiModelProperty("停用设备数量")
    private Long stopUseNumber;

    @ApiModelProperty("报废注销数量")
    private Long scrapCancel;


    public static void sortList(List<JgBizEquipStateCountVo> list, String sortByField, String sortOrder) {
        Comparator<JgBizEquipStateCountVo> comparator;
        switch (sortByField) {
            case "totalNumber":
                comparator = Comparator.comparingLong(JgBizEquipStateCountVo::getTotalNumber);
                break;
            case "inUseNumber":
                comparator = Comparator.comparingLong(JgBizEquipStateCountVo::getInUseNumber);
                break;
            case "scrapCancel":
                comparator = Comparator.comparingLong(JgBizEquipStateCountVo::getScrapCancel);
                break;
            case "stopUseNumber":
                comparator = Comparator.comparingLong(JgBizEquipStateCountVo::getStopUseNumber);
                break;
            default:
                // 默认按 launchesNumber 字段排序
                comparator = Comparator.comparingLong(JgBizEquipStateCountVo::getTotalNumber);
                break;
        }

        if ("desc".equalsIgnoreCase(sortOrder)) {
            comparator = comparator.reversed();
        }

        list.sort(comparator);
    }

}

