package com.yeejoin.equipmanage.common.enums;

/**
 * @Description: 稳压泵相关枚举
 * @Author: GaoJianqiang
 * @Date: 2023/2/16 15:20
 */
public enum PressurePumpRelateEnum {

    FAULT("有", "有故障"),
    NOT_FAULT("无", "无故障"),
    PRESSURE_PUMP("PressurePump", "稳压泵标识"),
    ONE_HOUR_MINUTE("60", "60分钟"),
    IOT_INDEX_VALUE_TRUE("true", "物联指标值：true"),
    IOT_INDEX_VALUE_FALSE("false", "物联指标值：false"),
    HALF_HOUR("0.5", "半小时"),
    ONE_HOUR("1.0", "1小时"),
    TWO_HOUR("2.0", "2小时"),
    FOUR_HOUR("4.0", "4小时"),
    START_FIVE("5", "稳压泵启动5分钟"),
    PIPE_PRESSURE_DIFF("0.5", "管网压力差判定标准，> 0.05Mpa 异常， <= 0.05 正常"),
    PRESSURE_PUMP_START_BEFORE_MINUTE("-5", "稳压泵启泵前分钟数"),
    PIPE_PRESSURE_NORMAL_STATUS("正常", "稳压泵管网压力正常状态"),
    PIPE_PRESSURE_ABNORMAL_STATUS("异常", "稳压泵管网压力异常状态"),
    START("1", "稳压泵启动"),
    STOP("0", "稳压泵停止"),
    CREATED_TIME("createdTime", "物联采集信号创建时间属性"),
    UN_CLEAN_TIME("false", "未消除");

    private final String value;
    private final String desc;

    PressurePumpRelateEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
