package com.yeejoin.amos.api.openapi.enums;

import com.yeejoin.amos.api.openapi.validation.FieldValidation;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 通用气瓶字段枚举
 */
@Getter
public enum CylinderField implements FieldValidation {
    // 通用字段
    sequenceCode(new String[]{FillStage.ALL.getCode()}, "sequenceCode", true, true, "气瓶唯一标识码"),
    cylinderType(new String[]{FillStage.ALL.getCode()}, "cylinderType", true, false, "气瓶类型"),
    fillingBeforeId(new String[]{FillStage.ALL.getCode()}, "fillingBeforeId", true, true, "充装前检查Id"),
    inspectorUserNum(new String[]{FillStage.ALL.getCode()}, "inspectorUserNum", true, false, "作业人员证书编号"),
    inspectorUser(new String[]{FillStage.ALL.getCode()}, "inspectorUser", true, false, "作业人员姓名"),

    inspectionDate(new String[]{FillStage.BEFORE.getCode(), FillStage.AFTER.getCode()}, "inspectionDate", true, false, "检测时间"),

    gunNumber(new String[]{FillStage.FILLING.getCode()}, "gunNumber", true, false, "充装枪编号"),
    fillingStartTime(new String[]{FillStage.FILLING.getCode()}, "fillingStartTime", true, false, "充装开始时间"),
    fillingEndTime(new String[]{FillStage.FILLING.getCode()}, "fillingEndTime", true, false, "充装结束时间");

    @Getter
    public enum FillStage {
        BEFORE("before", "充装前"),
        FILLING("filling", "充装中"),
        AFTER("after", "充装后"),
        ALL("all", "所有");
        private final String code;
        private final String desc;

        FillStage(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    private final String[] stage;
    private final String fieldName;
    private final boolean required;
    private final boolean unique;
    private final String desc;

    CylinderField(String[] stage, String fieldName, boolean required, boolean unique, String desc) {
        this.stage = stage;
        this.fieldName = fieldName;
        this.required = required;
        this.unique = unique;
        this.desc = desc;
    }

    @Override
    public boolean isRequired() {
        return required;
    }

    @Override
    public boolean isUnique() {
        return unique;
    }

    @Override
    public String getFieldName() {
        return fieldName;
    }

    public static List<String> getRequiredFields(String stage) {
        return Arrays.stream(values())
                .filter(field -> (Arrays.asList(field.stage).contains(stage) || Arrays.stream(field.stage).anyMatch(s -> s.equals(FillStage.ALL.getCode()))))
                .filter(FieldValidation::isRequired)
                .map(FieldValidation::getFieldName)
                .collect(Collectors.toList());
    }

    public static List<String> getRequiredFields() {
        return Arrays.stream(values())
                .filter(FieldValidation::isRequired)
                .map(FieldValidation::getFieldName)
                .collect(Collectors.toList());
    }

    public static List<String> getUniqueFields(String stage) {
        return Arrays.stream(values())
                .filter(field -> (Arrays.asList(field.stage).contains(stage) || Arrays.stream(field.stage).anyMatch(s -> s.equals(FillStage.ALL.getCode()))))
                .filter(FieldValidation::isUnique)
                .map(FieldValidation::getFieldName)
                .collect(Collectors.toList());
    }

    public static List<String> getUniqueFields() {
        return Arrays.stream(values())
                .filter(FieldValidation::isUnique)
                .map(FieldValidation::getFieldName)
                .collect(Collectors.toList());
    }

    public static void main(String[] args) {
        System.out.println(CylinderField.getRequiredFields(FillStage.BEFORE.code));
        System.out.println(CylinderField.getRequiredFields(FillStage.AFTER.code));
        System.out.println(CylinderField.getUniqueFields(FillStage.AFTER.code));
    }
}
