package com.yeejoin.amos.boot.module.elevator.flc.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.TzCarcylFillInfoDto;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.TzCarcylInspectDto;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.TzCarcylRegDto;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.elevator.flc.api.entity.TzCarcylReg;

import java.util.List;

/**
 * 车用气瓶使用登记信息（清洗后） Mapper 接口
 *
 * @author duanwei
 * @date 2022-08-08
 */
public interface TzCarcylMapper extends BaseMapper<TzCarcylReg> {

    /**
     * @param page 分頁内容
     * @param TzCarcylRegDto 筛选内容
     * @return
     */
    IPage<TzCarcylRegDto> pageByOrgCode(Page<TzCarcylRegDto> page, TzCarcylRegDto TzCarcylRegDto, String superviseOrgCode);

    IPage<TzCarcylRegDto> pageByCompanyCode(Page<TzCarcylRegDto> page, TzCarcylRegDto TzCarcylRegDto, String companyCode);

    TzCarcylRegDto getUserInfoger(String sequenceNbr);

    String getUseNum(String sequenceNbr);

    List<TzCarcylFillInfoDto> getFillingInfo(String useCode);

    List<TzCarcylInspectDto> getCheckingInfo(String useCode);
}
