package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.common.api.dto.BaseEnterpriseVideoNodeDto;
import com.yeejoin.amos.boot.module.common.api.entity.BaseEnterpriseVideoNode;
import com.yeejoin.amos.boot.module.common.api.mapper.BaseEnterpriseVideoNodeMapper;
import com.yeejoin.amos.boot.module.common.api.service.IBaseEnterpriseVideoNodeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

/**
 * 单位下摄像头表服务实现类
 *
 * @author system_generator
 * @date 2024-10-09
 */
@Service
@Slf4j
public class BaseEnterpriseVideoNodeServiceImpl extends BaseService<BaseEnterpriseVideoNodeDto, BaseEnterpriseVideoNode, BaseEnterpriseVideoNodeMapper> implements IBaseEnterpriseVideoNodeService {
    public Boolean saveOrUpdates(BaseEnterpriseVideoNode enterpriseVideoNode, String cameraIndexCode){
        return this.saveOrUpdate(enterpriseVideoNode, new QueryWrapper<BaseEnterpriseVideoNode>().lambda().eq(BaseEnterpriseVideoNode::getCameraIndexCode, cameraIndexCode));
    }
}