package com.yeejoin.amos.boot.module.common.biz.utils;

import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import com.yeejoin.amos.boot.module.common.api.dto.ITechParamDefine;
import com.yeejoin.amos.boot.module.common.api.dto.TechParamItem;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;

import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

public class TechParamUtil {
    private static final Set<Class<? extends ITechParamDefine>> subClasses;
    private static final Map<String, List<TechParamItem>> techParamsMetaMap = new ConcurrentHashMap<>();

    static {
        //▼ 指定扫描包路径（根据实际项目调整）
        Reflections reflections = new Reflections("com.yeejoin.amos.boot.module.common.api.dto");
        //▼ 获取所有继承ITechParamsMeta的类
        subClasses = reflections.getSubTypesOf(ITechParamDefine.class);
    }

    public static List<TechParamItem> getParamMetaList(String equListCode) {
        return techParamsMetaMap.computeIfAbsent(equListCode, (key) -> {
            List<TechParamItem> techParamItems = new ArrayList<>();
            for (Class<? extends ITechParamDefine> subClass : subClasses) {
                Field[] fields = subClass.getDeclaredFields();
                Group group = subClass.getAnnotation(Group.class);
                if (group != null && equListCode.equals(group.value())) {
                    for (Field field : fields) {
                        field.setAccessible(true);
                        TechParamItem techParamItem = getTechParamItem(equListCode, field);
                        techParamItems.add(techParamItem);
                    }
                }
            }
            return techParamItems;
        });
    }

    public static void main(String[] args) {
        List<TechParamItem> techParamItems = getParamMetaList("3000", "3300", "3320");
        System.out.println(techParamItems);
    }

    private static TechParamItem getTechParamItem(String equListCode, Field field) {
        TechnicalParameter technicalParameter = field.getAnnotation(TechnicalParameter.class);
        TechParamItem techParamItem = new TechParamItem();
        techParamItem.setParamKey(technicalParameter.key());
        techParamItem.setParamLabel(technicalParameter.label());
        techParamItem.setEquListCode(equListCode);
        techParamItem.setParamType(technicalParameter.type());
        techParamItem.setDictCode(technicalParameter.dictCode());
        techParamItem.setUnit(technicalParameter.unit());
        return techParamItem;
    }

    public static List<TechParamItem> getParamMetaList(String equListCode, String equCategoryCode, String equDefineCode, String... tags) {
        List<TechParamItem> techParamItems = new ArrayList<>();
        for (Class<? extends ITechParamDefine> subClass : subClasses) {
            Field[] fields = subClass.getDeclaredFields();
            Group group = subClass.getAnnotation(Group.class);
            if (group != null && equListCode.equals(group.value())) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    TechnicalParameter technicalParameter = field.getAnnotation(TechnicalParameter.class);
                    // 设备类别配置空时代表，全部都有
                    boolean equCategoryMatch = technicalParameter.equCategory().length == 0 || StringUtils.isEmpty(equCategoryCode) || Arrays.asList(technicalParameter.equCategory()).contains(equCategoryCode);
                    // 设备品种配置空时代表，全部都有
                    boolean equDefineMatch = technicalParameter.equDefine().length == 0 || StringUtils.isEmpty(equDefineCode) || Arrays.asList(technicalParameter.equDefine()).contains(equDefineCode);
                    // 标签是否匹配, 默认匹配
                    boolean tagMatch = true;
                    if (tags != null && tags.length > 0) {
                        List<String> filterTags = Arrays.asList(tags);
                        tagMatch = filterTags.stream().allMatch(tag-> Arrays.stream(technicalParameter.tags()).sequential().anyMatch(e->e.contains(tag)));
                    }
                    // 指定设备类别下默认字段设置
                    boolean ignoreField = false;
                    if (StringUtils.isEmpty(equDefineCode) && StringUtils.isNotEmpty(equCategoryCode) && technicalParameter.ignoreCategoryConf().length > 0) {
                        ignoreField = Arrays.asList(technicalParameter.ignoreCategoryConf()).contains(equCategoryCode);
                    }
                    if (!ignoreField && equCategoryMatch && equDefineMatch && tagMatch) {
                        TechParamItem techParamItem = getTechParamItem(equListCode, field);
                        techParamItems.add(techParamItem);
                    }
                }
            }
        }
        return techParamItems;
    }

    public static Class<? extends ITechParamDefine> getParamClazz(String equListCode) {
        for (Class<? extends ITechParamDefine> subClass : subClasses) {
            Group group = subClass.getAnnotation(Group.class);
            if (group != null && equListCode.equals(group.value())) {
                return subClass;
            }
        }
        throw new RuntimeException("not found equListCode:{ " + equListCode + "} clazz");
    }
}

