package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 使用登记表补证
 *
 * @author system_generator
 * @date 2025-03-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("tzs_jg_certificate_replenish")
public class JgCertificateReplenish extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备种类编码
     */
    @TableField("equ_list_code")
    private String equListCode;

    /**
     * 设备种类
     */
    @TableField("equ_list")
    private String equList;

    /**
     * 设备类别编码
     */
    @TableField("equ_category_code")
    private String equCategoryCode;

    /**
     * 设备类别
     */
    @TableField("equ_category")
    private String equCategory;

    /**
     * 申请编号
     */
    @TableField("apply_no")
    private String applyNo;

    /**
     * 申请日期
     */
    @TableField("apply_date")
    private Date applyDate;

    /**
     * 申请状态
     */
    @TableField("apply_status")
    private String applyStatus;

    /**
     * 申请状态
     */
    @TableField(exist = false)
    private String applyStatusDes;

    /**
     * 是否企业
     */
    @TableField(exist = false)
    private Boolean isCompany;

    /**
     * 使用单位统一信用代码
     */
    @TableField("use_unit_code")
    private String useUnitCode;

    /**
     * 使用单位名称
     */
    @TableField("use_unit_name")
    private String useUnitName;

    /**
     * 接收机构代码
     */
    @TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 接收机构名称
     */
    @TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 使用登记编号
     */
    @TableField("use_registration_code")
    private String useRegistrationCode;

    /**
     * 使用登记证补证申请表附件
     */
    @TableField("application_form_file")
    private String applicationFormFile;

    /**
     * 其他附件
     */
    @TableField("other_accessories")
    private String otherAccessories;

    /**
     * 补领原因 0 遗失；1 损毁
     */
    @TableField("application_reason")
    private String applicationReason;

    /**
     * 遗失或者损毁时间
     */
    @TableField("loss_damage_time")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date lossDamageTime;

    /**
     * 安全管理员名称
     */
    @TableField("safety_manager_name")
    private String safetyManagerName;

    /**
     * 安全管理员电话
     */
    @TableField("safety_manager_phone")
    private String safetyManagerPhone;

    /**
     * 任务发起人id
     */
    @TableField("promoter")
    private String promoter;

    /**
     * 流程实例id
     */
    @TableField("instance_id")
    private String instanceId;

    /**
     * 下步执行角色/人id
     */
    @TableField("next_execute_ids")
    private String nextExecuteIds;

    /**
     * 下一节点可执行人逗号分割
     */
    @TableField("next_execute_user_ids")
    private String nextExecuteUserIds;

    /**
     * 下一步任务ID
     */
    @TableField("next_task_id")
    private String nextTaskId;

    /**
     * 受理完成日期
     */
    @TableField("accept_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date acceptDate;

    /**
     * 补证日期
     */
    @TableField("reissue_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date reissueDate;

    /**
     * 作废时间
     */
    @TableField("cancel_date")
    private Date cancelDate;

    /**
     * 作废人id
     */
    @TableField("cancel_user_id")
    private String cancelUserId;

    /**
     * 作废原因
     */
    @TableField("cancel_reason")
    private String cancelReason;

    /**
     * 创建时间
     */
    @TableField("create_date")
    private Date createDate;

    /**
     * 创建人id
     */
    @TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 是否车用气瓶1是，0不是（特种气瓶使用）
     */
    @TableField("whether_vehicle_cylinder")
    private String whetherVehicleCylinder;

    /**
     * 设备使用地址
     */
    @TableField("equ_use_address")
    private String equUseAddress;

    /**
     * 使用登记证补证申请表URL
     */
    @TableField("application_form_file_url")
    private String applicationFormFileUrl;

    @TableField(exist = false)
    private String processAdvice;
}
