package com.yeejoin.amos.boot.module.jg.biz.edit.factory;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler.FormatService;
import com.yeejoin.amos.boot.module.jg.biz.edit.utils.JsonDiffUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.Objects;

@Component
@RequiredArgsConstructor
public class JsonColumnDiffHandler implements ColumnDiff {

    private final FormatService formatService;

    @Override
    public boolean supports(Class<?> type) {
        return type == JSON.class;
    }

    @Override
    public <T> FieldChangeMeta handleWithWrapper(FieldDisplayDefine displayDefine, Object oldVal, Object newVal, Field field, Group group, String changeId, TableField tableField, UpdateWrapper<T> wrapper) {
        if (!JsonDiffUtil.jsonEqualsIgnoreType((String) oldVal, (String) newVal)) {
            String columnName = tableField.value();
            if (tableField.exist()) {
                wrapper.set(columnName, newVal);
            }
            String fieldName = displayDefine.value();
            FieldChangeMeta fieldChangeMeta = new FieldChangeMeta();
            fieldChangeMeta.setColumnKey(field.getName());
            fieldChangeMeta.setColumnFamily(group.value());
            fieldChangeMeta.setColumnLabel(fieldName);
            fieldChangeMeta.setChangeId(changeId);
            fieldChangeMeta.setIsRepeatColumn(displayDefine.isRepeatColumn());
            // 字段类型前端渲染时使用
            fieldChangeMeta.setColumnType(displayDefine.type().getSimpleName());
            fieldChangeMeta.setColumnOldValue(Objects.toString(oldVal, null));
            fieldChangeMeta.setColumnNewValue(Objects.toString(newVal, null));
            fieldChangeMeta.setDisplayOldValue(formatService.format(displayDefine, fieldChangeMeta.getColumnOldValue()));
            fieldChangeMeta.setDisplayNewValue(formatService.format(displayDefine, fieldChangeMeta.getColumnNewValue()));
            return fieldChangeMeta;
        }
        return null;
    }

    @Override
    public FieldChangeMeta handleNoWrapper(FieldDisplayDefine displayDefine, Object oldVal, Object newVal, Field field, Group group, String changeId) {
        if (!JsonDiffUtil.jsonEqualsIgnoreType((String) oldVal, (String) newVal)) {
            String fieldName = displayDefine.value();
            FieldChangeMeta fieldChangeMeta = new FieldChangeMeta();
            fieldChangeMeta.setColumnKey(field.getName());
            fieldChangeMeta.setColumnFamily(group.value());
            fieldChangeMeta.setColumnLabel(fieldName);
            fieldChangeMeta.setChangeId(changeId);
            fieldChangeMeta.setIsRepeatColumn(displayDefine.isRepeatColumn());
            // 字段类型前端渲染时使用
            fieldChangeMeta.setColumnType(displayDefine.type().getSimpleName());
            fieldChangeMeta.setColumnOldValue(Objects.toString(oldVal, null));
            fieldChangeMeta.setColumnNewValue(Objects.toString(newVal, null));
            fieldChangeMeta.setDisplayOldValue(formatService.format(displayDefine, fieldChangeMeta.getColumnOldValue()));
            fieldChangeMeta.setDisplayNewValue(formatService.format(displayDefine, fieldChangeMeta.getColumnNewValue()));
            return fieldChangeMeta;
        }
        return null;
    }
}
