package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintainNoticeServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;

@Component
public class MaintainNoticeStrategyHandler implements ToBeSubmitDetailStrategy {

    @Autowired
    private JgMaintainNoticeServiceImpl jgMaintainNoticeService;

    @Override
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        Map<String, Map<String, Object>> notice = jgMaintainNoticeService.queryBySequenceNbr(sequenceNbr, reginParams.getCompany());
        Map<String, Object> maintainInfo = notice.get("maintainInfo");

        Map<String, Object> basic = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.WXGZ.getBusinessCode());
        basic.put("receiveOrgCreditCode", maintainInfo.get("receiveOrgCreditCode"));
        basic.put("code", maintainInfo.get("EQU_LIST_CODE"));
        basic.put("isTempEquip", true);
        basic.put("equCategory", maintainInfo.get("EQU_CATEGORY_CODE"));
        Map<String, Map<String, Object>> result = new HashMap<>();
        result.put("notice", maintainInfo);
        result.put("basic", basic);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_MAINTENANCE_NOTIFICATION.getName();
    }
}
