package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.editEquip;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.DefaultReminder;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 设备编辑-提醒处理器
 */
@Component
public class EditEquipReminderAdapter extends DefaultReminder {

    private final EditEquipParseService editEquipParseService;

    public EditEquipReminderAdapter(ApplicationContext applicationContext, EditEquipParseService editEquipParseService) {
        super(applicationContext);
        this.editEquipParseService = editEquipParseService;
    }

    private ReminderItemDto setRealTimeReminderItem(String bizId) {
        IdxBizJgRegisterInfo registerInfo = editEquipParseService.getIdxBizJgRegisterInfoService().getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, bizId).select(IdxBizJgRegisterInfo::getRecord, IdxBizJgRegisterInfo::getProductName));
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(bizId);
        reminderItemDto.setEquipName(registerInfo.getProductName());
        reminderItemDto.setDetailData(editEquipParseService.getEquipDetailByRecord(bizId));
        return reminderItemDto;
    }

    @Override
    protected List<ReminderItemDto> realtimeParse(String bizId) {
        return Collections.singletonList(setRealTimeReminderItem(bizId));
    }

    @Override
    public List<ReminderItemDto> jsonParse(String bizId, Map<String, Object> formData) {
        IdxBizJgRegisterInfo registerInfo = JSON.parseObject(JSON.toJSONString(formData), IdxBizJgRegisterInfo.class);
        IdxBizJgUseInfo bizJgUseInfo = JSON.parseObject(JSON.toJSONString(formData), IdxBizJgUseInfo.class);
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(bizId);
        reminderItemDto.setEquipNo(bizJgUseInfo.getUseInnerCode());
        reminderItemDto.setEquipName(registerInfo.getProductName());
        reminderItemDto.setDetailData(formData);
        return Collections.singletonList(reminderItemDto);
    }

    @Override
    public MatchItemDto setMatchItem(String bizId, Map<String, Object> formData) {
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        IdxBizJgRegisterInfo registerInfo = JSON.parseObject(JSON.toJSONString(formData), IdxBizJgRegisterInfo.class);
        IdxBizJgUseInfo idxBizJgUseInfo = JSON.parseObject(JSON.toJSONString(formData), IdxBizJgUseInfo.class);
        matchItemDto.setEquList(registerInfo.getEquList());
        matchItemDto.setEquCategory(registerInfo.getEquCategory());
        matchItemDto.setEquDefine(registerInfo.getEquDefine());
        matchItemDto.setWhetherVehicleCylinder(StringUtils.isNotEmpty(registerInfo.getWhetherVehicleCylinder()) ? registerInfo.getWhetherVehicleCylinder() : "0");
        matchItemDto.setIsRegister(idxBizJgUseInfo.getIsIntoManagement() && StringUtils.isNotEmpty(registerInfo.getUseOrgCode()));
        matchItemDto.setRegType(editEquipParseService.getRegTypeFromJson(idxBizJgUseInfo.getDataSource()));
        return matchItemDto;
    }

    @Override
    public MatchItemDto setMatchItem(String bizId) {
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        editEquipParseService.getReminderService().setEquCateInfoForEdit(bizId, matchItemDto);
        matchItemDto.setIsRegister(editEquipParseService.getIsRegister(bizId));
        matchItemDto.setRegType(editEquipParseService.getRegTypeForEdit(bizId));
        return matchItemDto;
    }

    @Override
    public String supportBizType() {
        return "JG_EDIT_EQUIP";
    }
}
