package com.yeejoin.amos.boot.module.statistics.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum RegulatoryUnitLevelEnum {

    /**
     * *监管单位类型
     */

    PROVINCE("省局", "headquarter"),
    CITY("市局", "prefecture-level"),
    COUNTY("区县局", "county");

    private final String name;
    private final String level;

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (RegulatoryUnitLevelEnum e : RegulatoryUnitLevelEnum.values()) {
            getName.put(e.level, e.name);
            getCode.put(e.name, e.level);
        }
    }

    public static RegulatoryUnitLevelEnum getEnumByLevelCode(String levelCode) {
        return Arrays.stream(RegulatoryUnitLevelEnum.values()).filter(r -> r.level.equals(levelCode)).findFirst().orElse(null);
    }
}
