package com.yeejoin.amos.boot.module.tcm.api.enums;

public enum RiskUnitType {

    DISPOSAL("处置单位"),  // 处置单位
    RECTIFICATION("整改单位"); // 整改单位

    private final String label;

    RiskUnitType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return label;
    }

    /**
     * 通过中文名称查找枚举
     */
    public static RiskUnitType fromLabel(String label) {
        for (RiskUnitType type : values()) {
            if (type.label.equals(label)) {
                return type;
            }
        }
        throw new IllegalArgumentException("未知的单位类型: " + label);
    }
}
