package com.yeejoin.amos.patrol.business.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

public class FeignBasicAuthRequestInterceptor implements RequestInterceptor {
    public FeignBasicAuthRequestInterceptor() {

    }

    @Override
    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes) requestAttributes;
        HttpServletRequest request = attributes.getRequest();
  
        //设置header
        String token = request.getHeader("token");
        if (null == token) {
            token = request.getHeader("X-Access-Token");
        }

        template.header("X-Access-Token", token);
        template.header("token", token);
        template.header("appKey", request.getHeader("appKey"));
        template.header("product", request.getHeader("product"));
        template.header("clientType", "feignClient");
    }

}
