package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 导出dto类
 */
@Data
@ApiModel(value="ExportDto", description="导出Dto类")
public class ExportDto {

   @ExcelIgnore
   private static final long serialVersionUID = 1L;

   @ApiModelProperty(value = "文件名称")
   private String fileName;

   @ApiModelProperty(value = "文件类型")
   private String fileType;

   @ApiModelProperty(value = "导出数据类型 0 全部数据 1 选中数据")
   private String dataType;

   @ApiModelProperty(value = "导出数据id")
   private String exportId;

   @ApiModelProperty(value = "导出字段")
   private String exportArray;

   @ApiModelProperty(value = "导出类型")
   private String exportType;

}
