package com.yeejoin.amos.boot.module.ymt.api.service;

import java.util.List;

/**
 * 生成码服务类
 * @author LiuLin
 * @date 2023-12-14
 */
public interface IGenerateCodeService {

    /**
     * 生成申请单编号(13位，GZ20231214000)
     * @param type 枚举类型
     * @param batchSize 生成个数
     * @return List
     */
    List<String> createApplicationFormCode(String type, int batchSize);

    /**
     * 生成设备注册编码(20位)
     * @param key key
     * @return 顺序编号
     */
    String createDeviceRegistrationCode(String key);

    /**
     * 生成使用登记证编号(13位，起11陕C00001(23))
     * @param key key
     * @return 顺序编号
     */
    String createUseRegistrationCode(String key);

    /**
     * 96333编码生成(7位)
     * @param key key
     * @return 96333顺序码
     */
    String createElevatorCode(String key);

    /**
     * 回退顺序码
     * @param key redisKey
     * @return bool
     */
    boolean reduceElevatorCode(String key);

    /**
     * 监管编码生成(7位)
     * @param key key
     * @return 7位监管编码生成
     */
    String createSupervisoryCode(String key);
    /**
     * 监管编码生成(7位)-导入批量生成
     * @param key key
     * @return 7位监管编码生成
     */
    List<String> createSupervisoryCodeBatch(String key, int batchSize);

    String initCode();
}
