package com.yeejoin.amos.boot.module.ys.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 救援案例管理
 *
 * @author system_generator
 * @date 2024-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_ys_emergency_case")
public class YsEmergencyCase extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 案例名称
     */
	@TableField("case_name")
    private String caseName;

    /**
     * 处置对象
     */
	@TableField("handle_object")
    private String handleObject;

    /**
     * 灾情发生地市
     */
	@TableField("city_disaster")
    private String cityDisaster;

    /**
     * 灾情发生省份
     */
	@TableField("province_disaster")
    private String provinceDisaster;

    /**
     * 群众伤亡情况
     */
	@TableField("person_casualties")
    private String personCasualties;

    /**
     * 灾情等级id
     */
	@TableField("disaster_level_id")
    private String disasterLevelId;

    /**
     * 灾情大类型id
     */
	@TableField("disaster_type_id")
    private String disasterTypeId;

    /**
     * 灾情结束时间
     */
	@TableField("disaster_end_time")
    private Date disasterEndTime;

    /**
     * 灾情开始时间
     */
	@TableField("disaster_start_time")
    private Date disasterStartTime;

    /**
     * 灾情细分类型id
     */
	@TableField("disaster_subdivide_id")
    private String disasterSubdivideId;

    /**
     * 视频信息
     */
	@TableField("video_info")
    private String videoInfo;

    /**
     * 图片信息
     */
	@TableField("pic_info")
    private String picInfo;

    /**
     * 文档信息
     */
	@TableField("file_info")
    private String fileInfo;

    /**
     * 音频信息
     */
	@TableField("audio_info")
    private String audioInfo;

    /**
     * 立案时间
     */
	@TableField("filing_time")
    private Date filingTime;

    /**
     * 灾情发生地点
     */
	@TableField("location_disaster")
    private String locationDisaster;

    /**
     * 灾情类型
     */
	@TableField("disaster_type")
    private String disasterType;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人id 
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

}
