package com.yeejoin.equipmanage.controller;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.response.Common3dResponse;
import com.yeejoin.equipmanage.common.response.Common3dResponseUtil;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.vo.EquipFor3DVO;
import com.yeejoin.equipmanage.common.vo.EquipmentSpecific3dVo;
import com.yeejoin.equipmanage.common.vo.RetrieveParams;
import com.yeejoin.equipmanage.service.IAreaService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivce;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.controller
 * @ClassName: View3dController
 * @Author: Jianqiang Gao
 * @Description: 三维controller
 * @Date: 2021/5/28 9:39
 * @Version: 1.0
 */
@RestController
@RequestMapping("/api/view3d")
@Api(tags = "数字换流站")
public class View3dController extends AbstractBaseController {

    @Autowired
    private IFireFightingSystemService fireFightingSystemService;
    @Lazy
    @Autowired
    private IEquipmentSpecificSerivce equipmentSpecificSerivce;

    @Autowired
    private IAreaService areaService;

    @GetMapping(value = "/get3dFightingSystemList")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取三维消防系统信息", notes = "获取三维消防系统信息")
    public ResponseModel get3dFightingSystemList() {
        return CommonResponseUtil.success(fireFightingSystemService.get3dFightingSystemList());
    }

//    @Permission
    @GetMapping(value = "/get3dFightingSysEquipCount")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取三维消防系统装备及统计信息", notes = "获取三维消防系统装备及统计信息")
    public ResponseModel get3dFightingSysEquipCount(@RequestParam(name = "pageNum") String pageNum,
                                                    @RequestParam(name = "pageSize") String pageSize,
                                                    @RequestParam(name = "id") Long id,
                                                    @RequestParam(name = "status", required = false) Integer status,
                                                    @RequestParam(name = "name", required = false) String name) {
        Map<String, Object> map = new HashMap<>();
//        List<EquipmentSpecific3dVo> equipList = equipmentSpecificSerivce.get3dFightingSysEquipList(id, status, name);
        List<LinkedHashMap> countMap = equipmentSpecificSerivce.get3dFightingSysEquipCount(id, status, name);
        EquipFor3DVO equipment = new EquipFor3DVO(id, status, name);
        map.put("equipList", this.listPage(pageNum, pageSize, equipment));
        map.put("countMap", countMap);
        return CommonResponseUtil.success(map);
    }


    public ResponseModel listPage(String pageNum, String pageSize, EquipFor3DVO equipment) {
        Page<EquipmentSpecific3dVo> pageBean;
        IPage<EquipmentSpecific3dVo> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = equipmentSpecificSerivce.listPage(pageBean, equipment);
        return CommonResponseUtil.success(page);
    }

    /**
     * 获取指定层级区域树，起步2级树
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("获取指定层级区域树")
    @GetMapping(value = "/getAreaTierTree")
    public Common3dResponse getAreaTierTree(@RequestParam Integer tier) {
        return Common3dResponseUtil.success(areaService.getAreaTierTree(tier));
    }

    @GetMapping(value = "/retrieve/all")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "风险区域、物理区域设备部件列表查询", notes = "风险区域、物理区域设备部件列表查询")
    public ResponseModel retrieveAll(@RequestBody RetrieveParams params) {

        String orgCode = this.getOrgCode();
        String token = this.getToken();
        String appKey = this.getAppKey();
        String product = this.getProduct();

//        return view3dService.retrieveAll(params.getType(),
//                params.getRiskSourceId(),
//                params.getInputText(),
//                params.getCurrent(),
//                params.getPageSize(),
//                orgCode,
//                params.getDataLevel(),
//                params.getProtectObjName(),
//                token,appKey,product);

        return null;
    }

}